% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/class-dtwSat.R
\docType{methods}
\name{getInternals}
\alias{getInternals}
\title{Get internals from dtwSat object}
\usage{
getInternals(object)
}
\arguments{
\item{object}{A \link[dtwSat]{dtwSat-class} object}
}
\value{
An object of class \code{\link[base]{list}} whose
 elements are internals from \link[dtwSat]{dtwSat-class} object
      \cr\code{costMatrix}: the cumulative cost matrix,
      \cr\code{stepPattern}: the \code{\link[dtw]{stepPattern}} used for the
      computation, see package \code{\link[dtw]{dtw}},
      \cr\code{N}: query length
      \cr\code{M}: reference length
      \cr\code{query}: the query time series, and
      \cr\code{template}: the reference time series.
}
\description{
This function retrieves cost matrix, inputs, and other
internal structures from dtwSat-class object
}
\examples{
names(query.list)
alig = dtwSat(query.list[["Soybean"]], template, keep=TRUE)
getInternals(alig)
}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
\seealso{
\code{\link[dtwSat]{dtwSat}}, \code{\link[dtwSat]{twdtw}}
}

