#' Completed
#' 
#' Tests whether a date time is complete.
#'
#' @param x A date time vector
#' @param sorted A flag indicating whether the values must be sorted.
#' @param unique A flag indicating whether the values must be unique.
#' @param units A string of the units.
#' @param ... Unused.
#' @return A flag indicating whether complete.
#' @export
dtt_completed <- function(x, ...) {
  UseMethod("dtt_completed")
}

#' @describeIn dtt_completed Test if Date vector is complete
#' @export
dtt_completed.Date <- function(x, units = "days", unique = TRUE, sorted = TRUE,  
                               ...) {
  check_scalar(units, .units_Date)
  check_flag(unique)
  check_flag(sorted)
  check_unused(...)

  if(anyNA(x)) return(NA)
  
  x <- dtt_floor(x, units)
  if(length(x) <= 1) return(TRUE)
  if(unique && anyDuplicated(x)) return(FALSE)
  if(sorted && is.unsorted(x)) return(FALSE)
  x <- unique(x)
  seq <- dtt_seq(min(x), max(x), units = units)
  identical(length(x), length(seq)) 
}

#' @describeIn dtt_completed Test if POSIXct vector is complete
#' @export
dtt_completed.POSIXct <- function(x, units = "seconds", unique = TRUE, sorted = TRUE,  
                               ...) {
  check_scalar(units, .units_POSIXct)
  check_flag(unique)
  check_flag(sorted)
  check_unused(...)

  if(anyNA(x)) return(NA)
  
  x <- dtt_floor(x, units)
  if(length(x) <= 1) return(TRUE)
  if(unique && anyDuplicated(x)) return(FALSE)
  if(sorted && is.unsorted(x)) return(FALSE)
  x <- unique(x)
  seq <- dtt_seq(min(x), max(x), units = units)
  identical(length(x), length(seq)) 
}

#' @describeIn dtt_completed Test if POSIXct vector is complete
#' @export
dtt_completed.hms <- function(x, units = "seconds", unique = TRUE, sorted = TRUE,  
                               ...) {
  check_scalar(units, .units_hms)
  check_flag(unique)
  check_flag(sorted)
  check_unused(...)

  if(anyNA(x)) return(NA)
  
  x <- dtt_floor(x, units)
  if(length(x) <= 1) return(TRUE)
  if(unique && anyDuplicated(x)) return(FALSE)
  if(sorted && is.unsorted(x)) return(FALSE)
  x <- unique(x)
  seq <- dtt_seq(min(x), max(x), units = units)
  identical(length(x), length(seq)) 
}
