#
#
#

setMethod("print", "dtiData",
function(x){
    cat("  Object of class", class(x),"\n")
    cat("  Generated by calls    :\n")
    print(x@call)
    cat("  Dimension            :", paste(x@ddim, collapse="x"), "\n")
    cat("  Number of Gradients  :", paste(x@ngrad, collapse="x"), "\n")
    cat("  Source-Filename      :", x@source, "\n")
    cat("  Slots                :\n")
    print(slotNames(x))
    invisible(NULL)
})
setMethod("print", "dtiTensor",
function(x){
    cat("  Object of class", class(x),"\n")
    cat("  Generated by calls    :\n")
    print(x@call)
    cat("  Dimension            :", paste(x@ddim, collapse="x"), "\n")
    cat("  Number of Gradients  :", paste(x@ngrad, collapse="x"), "\n")
    cat("  Source-Filename      :", x@source, "\n")
    cat("  Slots                :\n")
    print(slotNames(x))
    invisible(NULL)
})
setMethod("print", "dwiQball",
function(x){
    cat("  Object of class", class(x),"\n")
    cat("  Generated by calls    :\n")
    print(x@call)
    cat("  Dimension            :", paste(x@ddim, collapse="x"), "\n")
    cat("  Number of Gradients  :", paste(x@ngrad, collapse="x"), "\n")
    cat("  Source-Filename      :", x@source, "\n")
    cat("  Kind                 :", paste(x@what, collapse="x"), "\n")
    cat("  Order                :", paste(x@order, collapse="x"), "\n")
    cat("  Slots                :\n")
    print(slotNames(x))
    invisible(NULL)
})
setMethod("print","dtiIndices",
function(x){
    cat("  Object of class", class(x),"\n")
    cat("  Generated by calls    :\n")
    print(x@call)
    cat("  Dimension            :", paste(x@ddim, collapse="x"), "\n")
    cat("  Number of Gradients  :", paste(x@ngrad, collapse="x"), "\n")
    cat("  Source-Filename      :", x@source, "\n")
    cat("  Slots                :\n")
    print(slotNames(x))
    invisible(NULL)
})

setMethod("show", "dtiData",
function(object){
    cat("  Object of class", class(object),"\n")
    cat("  Generated by calls    :\n")
    print(object@call)
    cat("  Dimension            :", paste(object@ddim, collapse="x"), "\n")
    cat("  Number of Gradients  :", paste(object@ngrad, collapse="x"), "\n")
    cat("  Source-Filename      :", object@source, "\n")
    cat("  Slots                :\n")
    print(slotNames(object))
    invisible(NULL)
})
setMethod("show", "dtiTensor",
function(object){
    cat("  Object of class", class(object),"\n")
    cat("  Generated by calls    :\n")
    print(object@call)
    cat("  Dimension            :", paste(object@ddim, collapse="x"), "\n")
    cat("  Number of Gradients  :", paste(object@ngrad, collapse="x"), "\n")
    cat("  Source-Filename      :", object@source, "\n")
    cat("  Slots                :\n")
    print(slotNames(object))
    invisible(NULL)
})
setMethod("show", "dtiIndices",
function(object){
    cat("  Object of class", class(object),"\n")
    cat("  Generated by calls    :\n")
    print(object@call)
    cat("  Dimension            :", paste(object@ddim, collapse="x"), "\n")
    cat("  Number of Gradients  :", paste(object@ngrad, collapse="x"), "\n")
    cat("  Source-Filename      :", object@source, "\n")
    cat("  Slots                :\n")
    print(slotNames(object))
    invisible(NULL)
})


setMethod("summary", "dtiData",
function(object, ...){
    cat("  Object of class", class(object),"\n")
    cat("  Generated by calls    :\n")
    print(object@call)
    cat("  Source-Filename       :", object@source, "\n")
    cat("  Dimension             :", paste(object@ddim, collapse="x"), "\n")
    cat("  Number of Gradients   :", paste(object@ngrad, collapse="x"), "\n")
    cat("  Voxel extensions      :", paste(object@voxelext, collapse="x"), "\n")
    cat("  Index of S0-Images    :", paste(object@s0ind, collapse="x"), "\n")
    cat("  Quantiles of S0-values:","\n")
    print(signif(quantile(object@si[,,,object@s0ind],...),3))
    cat("  Mean S0-value         :", paste(z <- signif(mean(object@si[,,,object@s0ind]),3),collapse="x"), "\n")
    cat("  Threshold for mask    :", paste(signif(object@level,3),collapse="x"), "\n")
    cat("\n")
    invisible(NULL)
})
setMethod("summary", "dtiTensor",
function(object, ...){
    cat("  Object of class", class(object),"\n")
    cat("  Generated by calls    :\n")
    print(object@call)
    cat("  Source-Filename       :", object@source, "\n")
    cat("  Dimension             :", paste(object@ddim, collapse="x"), "\n")
    cat("  Number of Gradients   :", paste(object@ngrad, collapse="x"), "\n")
    cat("  Voxel extensions      :", paste(object@voxelext, collapse="x"), "\n")
    cat("  Quantiles of S0-values:","\n")
    print(signif(quantile(object@th0,...),3))
    cat("  Mean S0-value         :", paste(z <- signif(mean(object@th0),3),collapse="x"), "\n")
    cat("  Voxel in mask         :", paste(sum(object@mask), collapse="x"), "\n")
    cat("  Spatial smoothness    :", paste(signif(object@bw,3), collapse="x"), "\n")
    cat("  mean variance         :", paste(signif(mean(object@sigma[object@mask]),3), collapse="x"), "\n")
    cat("  hmax                  :", paste(object@hmax, collapse="x"), "\n")
    if(length(object@outlier)>0) cat("  Number of outliers    :", paste(length(object@outlier), collapse="x"), "\n")
    cat("\n")
    invisible(NULL)
})
setMethod("summary", "dwiQball",
function(object, ...){
    cat("  Object of class", class(object),"\n")
    cat("  Generated by calls    :\n")
    print(object@call)
    cat("  Source-Filename       :", object@source, "\n")
    cat("  Dimension             :", paste(object@ddim, collapse="x"), "\n")
    cat("  Number of Gradients   :", paste(object@ngrad, collapse="x"), "\n")
    cat("  Voxel extensions      :", paste(object@voxelext, collapse="x"), "\n")
    cat("  Kind                 :", paste(object@what, collapse="x"), "\n")
    cat("  Order                :", paste(object@order, collapse="x"), "\n")
    cat("  Quantiles of S0-values:","\n")
    print(signif(quantile(object@th0,...),3))
    cat("  Mean S0-value         :", paste(z <- signif(mean(object@th0),3),collapse="x"), "\n")
    cat("  Voxel in mask         :", paste(sum(object@mask), collapse="x"), "\n")
    cat("  Spatial smoothness    :", paste(signif(object@bw,3), collapse="x"), "\n")
    cat("  mean variance         :", paste(signif(mean(object@sigma[object@mask]),3), collapse="x"), "\n")
    cat("  hmax                  :", paste(object@hmax, collapse="x"), "\n")
    if(length(object@outlier)>0) cat("  Number of outliers    :", paste(length(object@outlier), collapse="x"), "\n")
    cat("\n")
    invisible(NULL)
})
setMethod("summary", "dtiIndices",
function(object, ...){
    cat("  Object of class", class(object),"\n")
    cat("  Generated by calls    :\n")
    print(object@call)
    cat("  Source-Filename       :", object@source, "\n")
    cat("  Dimension             :", paste(object@ddim, collapse="x"), "\n")
    cat("  Number of Gradients   :", paste(object@ngrad, collapse="x"), "\n")
    cat("  Voxel extensions      :", paste(object@voxelext, collapse="x"), "\n")
    cat("  Percentage of zero values      :",paste(signif(mean(object@fa==0)*100,3), "%",collapse="x"), "\n")
    cat("  Quantiles of positive FA-values:","\n")
    print(signif(quantile(object@fa[object@fa>0],...),3))
    cat("  Quantiles of positive GA-values:","\n")
    print(signif(quantile(object@ga[object@ga>0],...),3))
    cat("  Quantiles of positive MD-values:","\n")
    print(signif(quantile(object@md[object@md>0],...),3))
    cat("\n")
    invisible(NULL)
})

setMethod("plot", "dtiTensor", function(x, y, slice=1, view="axial", quant=0, minanindex=NULL, contrast.enh=1,what="FA", qrange=c(.01,.99),xind=NULL,yind=NULL,zind=NULL, mar=c(2,2,2,.2),mgp=c(2,1,0),...) {
  if(is.null(x@D)) cat("No diffusion tensor yet")
  adimpro <- require(adimpro)
  if(is.null(xind)) xind<-(1:x@ddim[1])
  if(is.null(yind)) yind<-(1:x@ddim[2])
  if(is.null(zind)) zind<-(1:x@ddim[3])
  if (view == "sagittal") {
    D <- x@D[,slice,yind,zind]
    mask <- x@mask[slice,yind,zind]
    n1 <- length(yind)
    n2 <- length(zind)
  } else if (view == "coronal") {
    D <- x@D[,xind,slice,zind]
    mask <- x@mask[xind,slice,zind]
    n1 <- length(xind)
    n2 <- length(zind)
  } else {
    D <- x@D[,xind,yind,slice]
    mask <- x@mask[xind,yind,slice]
    n1 <- length(xind)
    n2 <- length(yind)
  }
  if(what=="GA"){
  z <- .Fortran("dti2Dga",
                as.double(D),
                as.integer(n1),
                as.integer(n2),
                as.logical(mask),
                fa=double(n1*n2),
                md=double(n1*n2),
                andir=double(3*n1*n2),
                DUPL=FALSE,
                PACKAGE="dti")[c("fa","md","andir")]
  } else {
  z <- .Fortran("dti2Dfa",
                as.double(D),
                as.integer(n1),
                as.integer(n2),
                as.logical(mask),
                fa=double(n1*n2),
                md=double(n1*n2),
                andir=double(3*n1*n2),
                DUPL=FALSE,
                PACKAGE="dti")[c("fa","md","andir")]
   }
   oldpar <- par(mfrow=c(3,3),mar=mar,mgp=mgp,...)
#  now draw information to graphical device
   on.exit(par(oldpar))
   img<-D[1,,]
   rg<-quantile(img,qrange)
   img[img>rg[2]]<-rg[2]
   show.image(make.image(65535*img/max(img)))
   title(paste("Dxx: mean",signif(mean(D[mask]),3),"max",signif(max(D[1,,][mask]),3)))
   img<-D[2,,]
   rg<-quantile(img,qrange)
   img[img>rg[2]]<-rg[2]
   img[img<rg[1]]<-rg[1]
   show.image(make.image(img))
   title(paste("Dxy: min",signif(min(D[2,,][mask]),3),"max",signif(max(D[2,,][mask]),3)))
   img<-D[3,,]
   rg<-quantile(img,qrange)
   img[img>rg[2]]<-rg[2]
   img[img<rg[1]]<-rg[1]
   show.image(make.image(img))
   title(paste("Dxz: min",signif(min(D[3,,][mask]),3),"max",signif(max(D[3,,][mask]),3)))
   show.image(make.image(matrix(z$fa,n1,n2)))
   if(what=="GA"){
   title(paste("Anisotropy Index  (GA)  range:",signif(min(z$fa[mask]),3),"-",
                signif(max(z$fa[mask]),3)))
   } else {
   title(paste("Geodesic Anisotropy (FA)  range:",signif(min(z$fa[mask]),3),"-",
                signif(max(z$fa[mask]),3)))
   }
   img<-D[4,,]
   rg<-quantile(img,qrange)
   img[img>rg[2]]<-rg[2]
   img[img<rg[1]]<-rg[1]
   show.image(make.image(65535*img/max(img)))
   title(paste("Dyy: min",signif(min(D[4,,][mask]),3),"max",signif(max(D[4,,][mask]),3)))
   img<-D[5,,]
   rg<-quantile(img,qrange)
   img[img>rg[2]]<-rg[2]
   img[img<rg[1]]<-rg[1]
   show.image(make.image(img))
   title(paste("Dyz: min",signif(min(D[5,,][mask]),3),"max",signif(max(D[5,,][mask]),3)))
   andir.image(matrix(z$fa,n1,n2),array(z$andir,c(3,n1,n2)),quant=quant,minanindex=minanindex)
   title(paste("Anisotropy directions"))
   img <- matrix(z$md,n1,n2)
   show.image(make.image(65535*img/max(img)))
   if(what=="GA"){
   title(paste("Mean log diffusivity   range:",signif(min(z$md[mask]),3),"-",
                signif(max(z$md[mask]),3)))
   } else {
   title(paste("Mean diffusivity   range:",signif(min(z$md[mask]),3),"-",
                signif(max(z$md[mask]),3)))
   }
   img<-D[6,,]
   rg<-quantile(img,qrange)
   img[img>rg[2]]<-rg[2]
   img[img<rg[1]]<-rg[1]
   show.image(make.image(65535*img/max(img)))
   title(paste("Dzz: min",signif(min(D[6,,][mask]),3),"max",signif(max(D[6,,][mask]),3)))
   invisible(NULL)
})

setMethod("plot", "dtiData", function(x, y,slice=1, gradient=NULL, view= "axial", show=TRUE, density=FALSE, xind=NULL,yind=NULL,zind=NULL, mar=c(3,3,3,.3),mgp=c(2,1,0), ...) {
if(is.null(x@si)) cat("No dwi data yet")
maxsi <- max(x@si)
  if(is.null(xind)) xind<-(1:x@ddim[1])
  if(is.null(yind)) yind<-(1:x@ddim[2])
  if(is.null(zind)) zind<-(1:x@ddim[3])
if(is.null(gradient)) gradient <- x@s0ind[1]
if(gradient<1||gradient>x@ngrad) {
   warning("gradient number out of range, show s0 image")
   gradient <- x@s0ind[1]
}
if(density) { 
   z <- density(x@si[xind,yind,zind,gradient])
   if(show) {
      plot(z,main="Density of S0-values") 
      lines(c(x@level,x@level),c(0,max(z$y)),col=2)
   }
   return(invisible(z))
}
adimpro <- require(adimpro)
if (view == "sagittal") {
   if(slice<1||slice>x@ddim[1]) {
      warning("slice number out of range, show central slice")
      slice <- x@ddim[1]%/%2
   }
   img <- x@si[slice,yind,zind,gradient]
  } else if (view == "coronal") {
   if(slice<1||slice>x@ddim[2]) {
      warning("slice number out of range, show central slice")
      slice <- x@ddim[2]%/%2
   }
   img <- x@si[xind,slice,zind,gradient]
  } else {
   if(slice<1||slice>x@ddim[3]) {
      warning("slice number out of range, show central slice")
      slice <- x@ddim[3]%/%2
   }
   img <- x@si[xind,yind,slice,gradient]
  }
  oldpar <- par(mar=mar,mgp=mgp, ...)
  if(adimpro) {
     img <- make.image(65535*img/maxsi)
     if(show) show.image(img,...)
    } else if(show) {
      image(img,...)
    }
    par(oldpar)
    invisible(img)
}
)
setMethod("plot", "dwi", function(x, y, ...) cat("No implementation for class dwi\n"))

setMethod("plot", "dtiIndices", 
function(x, y, slice=1, view= "axial", method=1, quant=0, minanindex=NULL, show=TRUE, density=FALSE, contrast.enh=1,what="FA",xind=NULL,yind=NULL,zind=NULL, mar=c(3,3,3,.3),mgp=c(2,1,0), ...) {
  if(is.null(x@fa)) cat("No anisotropy index yet")
  if(!(method %in% 1:5)) {
      warning("method out of range, reset to 1")
      method <- 1
  }
  if(is.null(xind)) xind<-(1:x@ddim[1])
  if(is.null(yind)) yind<-(1:x@ddim[2])
  if(is.null(zind)) zind<-(1:x@ddim[3])
  if(density) { 
   x <- x[xind,yind,zind]
   z <- density(if(what=="FA") x@fa[x@fa>0] else x@ga[x@ga>0])
   if(show) {
      plot(z,main=paste("Density of positive",what,"-values")) 
   }
   return(invisible(z))
  }
  adimpro <- require(adimpro)
  oldpar <- par(mar=mar,mgp=mgp, ...)
#  if(what=="GA") maxga <- max(x@ga) 
#  if(what=="GA") maxga <- quantile(x@ga,0.99) 
#  resulting image needs to be rescaled 
  if (view == "sagittal") {
#    anindex <- if(what=="GA") pmin(x@ga[slice,yind,zind]/maxga, 1) else x@fa[slice,yind,zind]
    anindex <- if(what=="GA") tanh(x@ga[slice,yind,zind]) else x@fa[slice,yind,zind]
    if (method == 3) {
      andirection <- x@bary[,slice,yind,zind]
    } else {
      andirection <- x@andir[,slice,yind,zind]
    }
  } else if (view == "coronal") {
#    anindex <- if(what=="GA") pmin(x@ga[xind,slice,zind]/maxga, 1) else x@fa[xind,slice,zind]
    anindex <- if(what=="GA") tanh(x@ga[xind,slice,zind]) else x@fa[xind,slice,zind]
    if (method == 3) {
      andirection <- x@bary[,xind,slice,zind]
    } else {
      andirection <- x@andir[,xind,slice,zind]
    }
  } else {
#    anindex <- if(what=="GA") pmin(x@ga[xind,yind,slice]/maxga, 1) else x@fa[xind,yind,slice]
    anindex <- if(what=="GA") tanh(x@ga[xind,yind,slice]) else x@fa[xind,yind,slice]
    if (method == 3) {
      andirection <- x@bary[,xind,yind,slice]
    } else {
      andirection <- x@andir[,xind,yind,slice]
    }
  }
  anindex[anindex>1] <- 0
  anindex[anindex<0] <- 0
  if ((method==1) || (method==2) || (method==4)) {
    if(contrast.enh<1&&fa.contrast.enh>0) anindex <- pmin(anindex/contrast.enh,1)
    if(is.null(minanindex)) minanindex <- quantile(anindex,quant,na.rm=TRUE)
    if (diff(range(anindex,na.rm=TRUE)) == 0) minanindex <- 0
    if(method==1) {
      andirection[1,,] <- abs(andirection[1,,])
      andirection[2,,] <- abs(andirection[2,,])
      andirection[3,,] <- abs(andirection[3,,])
    } else if (method==2) {
      ind<-andirection[1,,]<0
      dim(andirection) <- c(3,prod(dim(ind)))
      andirection[,ind] <- - andirection[,ind]
      andirection[2,] <- (1+andirection[2,])/2
      andirection[3,] <- (1+andirection[3,])/2
      dim(andirection) <- c(3,dim(ind))
    } else {
      andirection[1,,] <- andirection[1,,]^2
      andirection[2,,] <- andirection[2,,]^2
      andirection[3,,] <- andirection[3,,]^2
    }
    andirection <- aperm(andirection,c(2,3,1))
    andirection <- andirection*as.vector(anindex)*as.numeric(anindex>minanindex)
    if(adimpro) {
      andirection[is.na(andirection)] <- 0
      andirection <- make.image(andirection,gamma=TRUE)
      if(show) show.image(andirection,...)
    } else if(show) {
      dim(anindex) <- dim(andirection)[2:3]
      image(anindex,...)
    }
    par(oldpar)
    invisible(andirection)
  } else if (method==3) {
    if(adimpro) {
      andirection[is.na(andirection)] <- 0
      bary <- make.image(aperm(andirection,c(2,3,1)))
      if(show) show.image(bary,...)
      par(oldpar)
      invisible(bary)
    } else if(show) {
      image(andirection[1,,],...)
    }
    par(oldpar)
    invisible(NULL)
  } else if (method==5) {
    if(adimpro) {
      andirection[is.na(andirection)] <- 0
      img.hsi.data <- array(0,dim=c(dim(andirection)[2:3],3))
      img.hsi.data[,,1] <- atan2(andirection[2,,],andirection[1,,])
      img.hsi.data[,,1] <- img.hsi.data[,,1] + pi*(img.hsi.data[,,1]<0)
      img.hsi.data[,,2] <- abs(acos(andirection[3,,]))
      img.hsi.data[,,3] <- anindex
      img.hsi <- make.image(img.hsi.data,gamma=TRUE,xmode="HSI")
      if(show) show.image(img.hsi,...)
      par(oldpar)
      invisible(img.hsi)
    } else if(show) {
      image(andirection[1,,],...)
    }
    par(oldpar)
    invisible(NULL)
  }
})

#
#
#

dtiData <- function(gradient,imagefile,ddim,xind=NULL,yind=NULL,zind=NULL,level=0,mins0value=0,maxvalue=10000,voxelext=c(1,1,1),orientation=c(1,3,5)) {
  args <- list(sys.call())
  if (any(sort((orientation)%/%2) != 0:2)) stop("invalid orientation \n")
  if (dim(gradient)[2]==3) gradient <- t(gradient)
  if (dim(gradient)[1]!=3) stop("Not a valid gradient matrix")
  ngrad <- dim(gradient)[2]
  s0ind <- (1:ngrad)[apply(abs(gradient),2,max)==0] 
  if (!(file.exists(imagefile))) stop("Image file does not exist")
  cat("Start Data reading",date(), "\n")
  zz <- file(imagefile,"rb")
#  si now contains all images (S_0 and S_I), ngrad includes 
#  number of zero gradients

  if (is.null(xind)) xind <- 1:ddim[1]
  if (is.null(yind)) yind <- 1:ddim[2]
  if (is.null(zind)) zind <- 1:ddim[3]
  si <- numeric()
  for (grad in 1:ngrad) {
    sitemp <- readBin(zz,"integer",prod(ddim),2,FALSE)
    dim(sitemp) <- ddim
    si <- c(si,sitemp[xind,yind,zind])
    cat(".")
  }
  close(zz)
  dim(si) <- c(length(xind),length(yind),length(zind),ngrad)
  dimsi <- dim(si)

#  si <- readBin(zz,"integer",prod(ddim)*ngrad,2,FALSE)
#  close(zz)
  cat("Data successfully read",date(), "\n")

#
#   set correct orientation
#
  xyz <- (orientation)%/%2+1
  swap <- orientation-2*(orientation%/%2)
  if(any(xyz!=1:3)) {
      abc <- 1:3
      abc[xyz] <- abc
      si <- aperm(si,c(abc,4))
      swap[xyz] <- swap
      voxelext[xyz] <- voxelext
      dimsi[xyz] <- dimsi[1:3]
      ddim[xyz] <- ddim[1:3]
      gradient[xyz,] <- gradient
  }
  if(swap[1]==1) {
      si <- si[dimsi[1]:1,,,] 
      gradient[1,] <- -gradient[1,]
      }
  if(swap[2]==1) {
      si <- si[,dimsi[2]:1,,]  
      gradient[2,] <- -gradient[2,]
      }
  if(swap[3]==0) {
      si <- si[,,dimsi[3]:1,]    
      gradient[3,] <- -gradient[3,]
      }
#
#   orientation set to radiological convention
#
  si <- .Fortran("initdata",
                 si=as.integer(si),
                 as.integer(dimsi[1]),
                 as.integer(dimsi[2]),
                 as.integer(dimsi[3]),
                 as.integer(dimsi[4]),
                 as.integer(maxvalue),
                 PACKAGE="dti")$si
#  this replaces the content off all voxel with elements <=0 or >maxvalue by 0
     dim(si) <- dimsi
  level <- max(mins0value,level*mean(si[,,,s0ind][si[,,,s0ind]>0])) # set level to level*mean  of positive s_0 values
  ddim0 <- as.integer(ddim)
  ddim <- as.integer(dim(si)[1:3])

  cat("Create auxiliary statistics",date(), " \n")
  rind <- replind(gradient)
  
  invisible(new("dtiData",
                call = args,
                si     = si,
                gradient = gradient,
                btb    = create.designmatrix.dti(gradient),
                ngrad  = ngrad, # = dim(btb)[2]
                s0ind  = s0ind, # indices of S_0 images
                replind = rind,
                ddim   = ddim,
                ddim0  = ddim0,
                xind   = xind,
                yind   = yind,
                zind   = zind,
                level  = level,
                sdcoef = rep(0,4),
                voxelext = voxelext,
                orientation = as.integer(c(0,2,5)),
                source = imagefile)
            )
}

readDWIdata <- function(gradient, dirlist, format, nslice, order = NULL,
                        xind=NULL, yind=NULL, zind=NULL,
                        level=0, mins0value=0, maxvalue=10000,
                        voxelext=NULL, orientation=c(1,3,5)) {
  # basic consistency checks
  args <- list(sys.call())
  if (!(format %in% c("DICOM","NIFTI","ANALYZE","AFNI")))
    stop("Cannot handle other formats then DICOM|NIFTI|ANALYZE|AFNI, found:",format)
  if (any(sort((orientation)%/%2) != 0:2)) stop("invalid orientation \n")
  if (dim(gradient)[2]==3) gradient <- t(gradient)
  if (dim(gradient)[1]!=3) stop("Not a valid gradient matrix")
  ngrad <- dim(gradient)[2]
  s0ind <- (1:ngrad)[apply(abs(gradient),2,max)==0] 
  if (is.null(zind)) zind <- 1:nslice

  # generate file list in specified order
  filelist <- NULL
  for (dd in dirlist) filelist <- c(filelist, paste(dd,list.files(dd),sep=.Platform$file.sep))
  if (format == "DICOM") {
    if (length(filelist) != ngrad * nslice)
      stop("Number of found files does not match ngrad*nslice",length(filelist))
    if (is.null(order)) {
      order <- 1:(ngrad*nslice)
    } else {
      if (length(order) != ngrad*nslice)
        stop("Length of order vector does not match ngrad*nslice")
    }
    dim(order) <- c(nslice,ngrad)
    order <- order[zind,]
    dim(order) <- NULL
    filelist <- filelist[order]
  } else {
    if (format =="ANALYZE") filelist <- unlist(strsplit(filelist[regexpr("\\.hdr$", filelist) != -1],"\\.hdr"))
    if (format =="AFNI") filelist <- filelist[regexpr("\\.HEAD$", filelist) != -1]
    if (length(filelist) != ngrad)
      stop("Number of found files does not match ngrad",length(filelist),"\nPlease provide each gradient cube in a separate file.")
    if (is.null(order)) {
      order <- 1:ngrad
    } else {
      if (length(order) != ngrad)
        stop("Length of order vector does not match ngrad")
    }
    filelist <- filelist[order]
  }
  # read all DICOM files
  cat("Start reading data",date(), "\n")
  si <- numeric()
  cat("\n")
  ddim <- NULL
  first <- TRUE
  i <- 0
  for (ff in filelist) {
    i <- i+1
    cat(".")
    if (format == "DICOM") {
      data <- read.DICOM(ff)
    } else if (format == "NIFTI") {
      data <- read.NIFTI(ff,setmask=FALSE)
    } else if (format == "ANALYZE") {
      data <- read.ANALYZE(ff,setmask=FALSE)
    } else if (format == "AFNI") {
      data <- read.AFNI(ff,setmask=FALSE)
    } 
    if (is.null(ddim)) ddim <- c(data$dim[1:2],nslice,ngrad)
    if (is.null(voxelext)) {
      if (!is.null(data$delta)) {
        if (!prod(voxelext == data$delta))
          warning("Voxel extension",voxelext,"is not found in data:",data$delta)
        voxelext <- data$delta
      } else {
        warning("Voxel extension neither found nor given!")
      }
    }
    if (is.null(xind)) xind <- 1:data$dim[1]
    if (is.null(yind)) yind <- 1:data$dim[2]
    if (format == "DICOM") {
      if(first){ 
         ttt <- extract.data(data)[xind,yind]
         nttt <- dim(ttt)
         n <- length(filelist)
         si <- numeric(n*prod(nttt))
         dim(si) <- c(nttt,n)
         si[,,1]<- ttt
         first <- FALSE
      } else {
         si[,,i] <- extract.data(data)[xind,yind]
      }
    } else {
      if(first){ 
         ttt <- extract.data(data)[xind,yind,zind,]
         nttt <- dim(ttt)
         n <- length(filelist)
         si <- numeric(n*prod(nttt))
         dim(si) <- c(nttt,n)
         if(length(nttt)==4) si[,,,,1]<- ttt else si[,,,1] <- ttt
         first <- FALSE
     } else {
      ttt <- extract.data(data)[xind,yind,zind,]
      if(length(nttt)==4) si[,,,,i] <- ttt else si[,,,i] <- ttt
      }
    }
  }
  cat("\n")
  dim(si) <- c(length(xind),length(yind),length(zind),ngrad)
  dimsi <- dim(si)
  cat("Data successfully read",date(), "\n")

  # redefine orientation
  xyz <- (orientation)%/%2+1
  swap <- orientation-2*(orientation%/%2)
  if(any(xyz!=1:3)) {
      abc <- 1:3
      abc[xyz] <- abc
      si <- aperm(si,c(abc,4))
      swap[xyz] <- swap
      voxelext[xyz] <- voxelext
      dimsi[xyz] <- dimsi[1:3]
      ddim[xyz] <- ddim[1:3]
      gradient[xyz,] <- gradient
  }
  if(swap[1]==1) {
      si <- si[dimsi[1]:1,,,] 
      gradient[1,] <- -gradient[1,]
      }
  if(swap[2]==1) {
      si <- si[,dimsi[2]:1,,]  
      gradient[2,] <- -gradient[2,]
      }
  if(swap[3]==0) {
      si <- si[,,dimsi[3]:1,]    
      gradient[3,] <- -gradient[3,]
      }
  # orientation set to radiological convention
  si <- .Fortran("initdata",
                 si=as.integer(si),
                 as.integer(dimsi[1]),
                 as.integer(dimsi[2]),
                 as.integer(dimsi[3]),
                 as.integer(dimsi[4]),
                 as.integer(maxvalue),
                 PACKAGE="dti")$si
  # this replaces the content off all voxel with elements <=0 or >maxvalue by 0
  dim(si) <- dimsi
  level <- max(mins0value,level*mean(si[,,,s0ind][si[,,,s0ind]>0])) # set level to level*mean  of positive s_0 values
  ddim0 <- as.integer(ddim)
  ddim <- as.integer(dim(si)[1:3])
    
  cat("Create auxiliary statistics",date(), " \n")
  rind <- replind(gradient)
  
  invisible(new("dtiData",
                call = args,
                si     = si,
                gradient = gradient,
                btb    = create.designmatrix.dti(gradient),
                ngrad  = ngrad, # = dim(btb)[2]
                s0ind  = s0ind, # indices of S_0 images
                replind = rind,
                ddim   = ddim,
                ddim0  = ddim0,
                xind   = xind,
                yind   = yind,
                zind   = zind,
                level  = level,
                sdcoef = rep(0,4),
                voxelext = voxelext,
                orientation = as.integer(c(0,2,5)),
                source = paste(dirlist,collapse="|"))
            )
}
#
#
#


dwi <- function(object,  ...) cat("This object has class",class(object),"\n")
setGeneric("dwi", function(object,  ...) 
standardGeneric("dwi"))


sdpar <- function(object,  ...) cat("No method defined for class:",class(object),"\n")

setGeneric("sdpar", function(object,  ...) standardGeneric("sdpar"))

setMethod("sdpar","dtiData",function(object,level=NULL,sdmethod="sd",interactive=TRUE){
# determine interval of linearity
if(!(sdmethod%in%c("sd","mad"))){
   warning("sdmethod needs to be either 'sd' or 'mad'")
   return(object)
}
if(is.null(level)) level <- object@level
s0ind<-object@s0ind
s0 <- object@si[,,,s0ind]
ls0ind <- length(s0ind)
A0 <- level
if(ls0ind>1) {
   dim(s0) <- c(prod(object@ddim),ls0ind)
   s0mean <- s0%*%rep(1/ls0ind,ls0ind)
   A1 <- quantile(s0mean[s0mean>0],.98)
   dim(s0mean) <- object@ddim
} else {
   A1 <- quantile(s0[s0>0],.98)
}
if(interactive) {
   accept <- FALSE
   ddim <- object@ddim
   bw <- min(bw.nrd(if(ls0ind>1) s0mean[s0mean>0] else s0[s0>0]),diff(range(if(ls0ind>1) s0mean else s0))/256)
   z <- density(if(ls0ind>1) s0mean[s0mean>0&s0mean<A1] else s0[s0>0&s0<A1],bw = bw,n=1024)
   indx1 <- trunc(0.05*ddim[1]):trunc(0.95*ddim[1])
   indx2 <- trunc(0.1*ddim[1]):trunc(0.9*ddim[1])
   indx3 <- trunc(0.15*ddim[1]):trunc(0.85*ddim[1])
   indy1 <- trunc(0.05*ddim[2]):trunc(0.95*ddim[2])
   indy2 <- trunc(0.1*ddim[2]):trunc(0.9*ddim[2])
   indy3 <- trunc(0.15*ddim[2]):trunc(0.85*ddim[2])
   indz1 <- trunc(0.05*ddim[3]):trunc(0.95*ddim[3])
   indz2 <- trunc(0.1*ddim[3]):trunc(0.9*ddim[3])
   indz3 <- trunc(0.15*ddim[3]):trunc(0.85*ddim[3])
   z1 <- density(if(ls0ind>1) s0mean[indx1,indy1,indz1][s0mean[indx1,indy1,indz1]>0] else s0[indx1,indy1,indz1][s0[indx1,indy1,indz1]>0],bw=bw,n=1024)
   z2 <- density(if(ls0ind>1) s0mean[indx2,indy2,indz2][s0mean[indx2,indy2,indz2]>0] else s0[indx2,indy2,indz2][s0[indx2,indy2,indz2]>0],bw=bw,n=1024)
   z3 <- density(if(ls0ind>1) s0mean[indx3,indy3,indz3][s0mean[indx3,indy3,indz3]>0] else s0[indx3,indy3,indz3][s0[indx3,indy3,indz3]>0],bw=bw,n=1024)
   n <- prod(ddim)
   n1 <- length(indx1)*length(indy1)*length(indz1)
   n2 <- length(indx2)*length(indy2)*length(indz2)
   n3 <- length(indx3)*length(indy3)*length(indz3)
   ylim <- range(z$y,z1$y*n1/n,z2$y*n2/n,z3$y*n3/n)
   while(!accept){
      plot(z,type="l",main="Density of S0 values and cut off point",ylim=ylim)
      lines(z1$x,z1$y*n1/n,col=2)
      lines(z2$x,z2$y*n2/n,col=3)
      lines(z3$x,z3$y*n3/n,col=4)
      lines(c(A0,A0),c(0,max(z$y)/2),col=2,lwd=2)
      legend(min(A0,0.25*max(z$x)),ylim[2],c("Full cube",paste("Central",(n1*100)%/%n,"%"),
      paste("Central",(n2*100)%/%n,"%"),paste("Central",(n3*100)%/%n,"%")),col=1:4,lwd=rep(1,4))
      cat("A good cut off point should be left of support of the density of grayvalues within the head\n")
      a <- readline(paste("Accept current cut off point",A0," (Y/N):"))
      if (toupper(a) == "N") {
         cutpoint <-  readline("Provide value for cut off point:")
         cutpoint <- if(!is.null(cutpoint)) as.numeric(cutpoint) else A0
         if(!is.na(cutpoint)) {
            A0 <- cutpoint
            level <- cutpoint
         }
      } else {
         accept <- TRUE
      }
   }
}
# determine parameters for linear relation between standard deviation and mean
if(ls0ind>1) {
   s0sd <- apply(s0,1,sdmethod)
   ind <- s0mean>A0&s0mean<A1
   sdcoef <- coefficients(lm(s0sd[ind]~s0mean[ind]))
} else {
   sdcoef <- awslinsd(s0,hmax=5,mask=NULL,A0=A0,A1=A1)$vcoef
}
object@level <- level
object@sdcoef <- c(sdcoef,A0,A1)
cat("Estimated parameters:",signif(sdcoef[1:2],3),"Interval of linearity",signif(A0,3),"-",signif(A1,3),"\n")
object
}
)

dtiTensor <- function(object,  ...) cat("No DTI tensor calculation defined for this class:",class(object),"\n")

setGeneric("dtiTensor", function(object,  ...) standardGeneric("dtiTensor"))

setMethod("dtiTensor","dtiData",function(object, method="nonlinear",varmethod="replicates",varmodel="local") {
#  available methods are 
#  "linear" - use linearized model (log-transformed)
#  "nonlinear" - use nonlinear model with parametrization according to Koay et.al. (2006)
  args <- sys.call(-1)
  args <- c(object@call,args)
  ngrad <- object@ngrad
  ddim <- object@ddim
  s0ind <- object@s0ind
  ns0 <- length(s0ind)
  sdcoef <- object@sdcoef
  if(all(sdcoef==0)) {
    cat("No parameters for model of error standard deviation found\n estimating these parameters\n You may prefer to run sdpar before calling dtiTensor")
    sdcoef <- sdpar(object,interactive=FALSE)@sdcoef
  }
  z <- .Fortran("outlier",
                as.integer(object@si),
                as.integer(prod(ddim)),
                as.integer(ngrad),
                as.logical((1:ngrad)%in%s0ind),
                as.integer(ns0),
                si=integer(prod(ddim)*ngrad),
                index=integer(prod(ddim)),
                lindex=integer(1),
                DUPL=FALSE,
                PACKAGE="dti")[c("si","index","lindex")]
  si <- array(z$si,c(ddim,ngrad))
  index <- if(z$lindex>0) z$index[1:z$lindex] else numeric(0)
  rm(z)
  gc()
  if(method=="linear"){
     ngrad0 <- ngrad - length(s0ind)
     s0 <- si[,,,s0ind]
     si <- si[,,,-s0ind]
     if(ns0>1) {
         dim(s0) <- c(prod(ddim),ns0)
         s0 <- s0 %*% rep(1/ns0,ns0)
         dim(s0) <- ddim
     }
     mask <- s0 > object@level
     mask <- connect.mask(mask)
     dim(s0) <- dim(si) <- NULL
     ttt <- -log(si/s0)
     ttt[is.na(ttt)] <- 0
     ttt[(ttt == Inf)] <- 0
     ttt[(ttt == -Inf)] <- 0
     dim(ttt) <- c(prod(ddim),ngrad0)
     ttt <- t(ttt)
     cat("Data transformation completed ",date(),"\n")

     btbsvd <- svd(object@btb[,-s0ind])
     solvebtb <- btbsvd$u %*% diag(1/btbsvd$d) %*% t(btbsvd$v)
     D <- solvebtb%*% ttt
     cat("Diffusion tensors generated ",date(),"\n")

     res <- ttt - t(object@btb[,-s0ind]) %*% D
     rss <- res[1,]^2
     for(i in 2:ngrad0) rss <- rss + res[i,]^2
     dim(rss) <- ddim
     sigma2 <- rss/(ngrad0-6)
     D[c(1,4,6),!mask] <- 1e-6
     D[c(2,3,5),!mask] <- 0
#  replace non-tensors (with negative eigenvalues) by a small isotropic tensor 
      ind <- array(.Fortran("dti3Dev",
                           as.double(D),
                           as.integer(ddim[1]),
                           as.integer(ddim[2]),
                           as.integer(ddim[3]),
                           as.logical(mask),
                           ev=double(3*prod(ddim)),
                           DUPL=FALSE,
                           PACKAGE="dti")$ev,c(3,ddim))[1,,,]<1e-6
       if(sum(ind&mask)>0){
           D[c(1,4,6),ind&mask] <- 1e-6
           D[c(2,3,5),ind&mask] <- 0
       }
     dim(D) <- c(6,ddim)
     dim(res) <- c(ngrad0,ddim)
     cat("Variance estimates generated ",date(),"\n")
     th0 <- array(s0,object@ddim)
     th0[!mask] <- 0
     gc()
  } else {
#  method == "nonlinear" 
     ngrad0 <- ngrad
     si <- aperm(si,c(4,1:3))
     s0 <- si[s0ind,,,]
     if(ns0>1) {
         dim(s0) <- c(ns0,prod(ddim))
         s0 <- rep(1/ns0,ns0)%*%s0
         dim(s0) <- ddim
     }
     mask <- s0 > object@level
     mask <- connect.mask(mask)
     cat("start nonlinear regression",date(),"\n")
     z <- .Fortran("nlrdtirg",
                as.integer(si),
                as.integer(ngrad),
                as.integer(ddim[1]),
                as.integer(ddim[2]),
                as.integer(ddim[3]),
                as.logical(mask),
                as.double(object@btb),
                as.double(sdcoef),
                th0=as.double(s0),
                D=double(6*prod(ddim)),
                as.integer(200),
                as.double(1e-6),
                res=double(ngrad*prod(ddim)),
                rss=double(prod(ddim)),
                double(ngrad),
                PACKAGE="dti",DUP=FALSE)[c("th0","D","res","rss")]
     cat("successfully completed nonlinear regression ",date(),"\n")
     dim(z$th0) <- ddim
     dim(z$D) <- c(6,ddim)
     dim(z$res) <- c(ngrad,ddim)
     dim(z$rss) <- ddim
     df <- sum(table(object@replind)-1)
     res <- z$res
     D <- z$D
     rss <- z$rss
     th0 <- z$th0
     sigma2 <- array(0,c(1,1,1))
     rm(z)
     gc()
  }
  lags <- c(5,5,3)
  scorr <- .Fortran("mcorr",as.double(res),
                   as.logical(mask),
                   as.integer(ddim[1]),
                   as.integer(ddim[2]),
                   as.integer(ddim[3]),
                   as.integer(ngrad0),
                   double(prod(ddim)),
                   double(prod(ddim)),
                   scorr = double(prod(lags)),
                   as.integer(lags[1]),
                   as.integer(lags[2]),
                   as.integer(lags[3]),
                   PACKAGE="dti",DUP=FALSE)$scorr
  dim(scorr) <- lags
  scorr[is.na(scorr)] <- 0
  cat("estimated spatial correlations",date(),"\n")
  cat("first order  correlation in x-direction",signif(scorr[2,1,1],3),"\n")
  cat("first order  correlation in y-direction",signif(scorr[1,2,1],3),"\n")
  cat("first order  correlation in z-direction",signif(scorr[1,1,2],3),"\n")

  scorr[is.na(scorr)] <- 0
  bw <- optim(c(2,2,2),corrrisk,method="L-BFGS-B",lower=c(.2,.2,.2),
  upper=c(3,3,3),lag=lags,data=scorr)$par
  bw[bw <= .25] <- 0
  cat("estimated corresponding bandwidths",date(),"\n")
  ev <- array(.Fortran("dti3Dev",
                       as.double(D),
                       as.integer(ddim[1]),
                       as.integer(ddim[2]),
                       as.integer(ddim[3]),
                       as.logical(mask),
                       ev=double(3*prod(ddim)),
                       DUPL=FALSE,
                       PACKAGE="dti")$ev,c(3,ddim))
  scale <- quantile(ev[3,,,][mask],.95)
  cat("estimated scale information",date(),"\n")  
  invisible(new("dtiTensor",
                call  = args,
                D     = D,
                th0   = th0,
                sigma = sigma2,
                scorr = scorr, 
                bw = bw, 
                mask = mask,
                hmax = 1,
                gradient = object@gradient,
                btb   = object@btb,
                ngrad = object@ngrad, # = dim(btb)[2]
                s0ind = object@s0ind,
                replind = object@replind,
                ddim  = object@ddim,
                ddim0 = object@ddim0,
                xind  = object@xind,
                yind  = object@yind,
                zind  = object@zind,
                voxelext = object@voxelext,
                level = object@level,
                orientation = object@orientation,
                source = object@source,
                outlier = index,
                scale = scale,
                method = method)
            )
})

dwiQball <- function(object,  ...) cat("No DWI Q-ball calculation defined for this class:",class(object),"\n")

setGeneric("dwiQball", function(object,  ...) standardGeneric("dwiQball"))

setMethod("dwiQball","dtiData",function(object,what="Qball",order=4,lambda=0){
  args <- sys.call(-1)
  args <- c(object@call,args)
  if (!(what %in% c("Qball","ADC"))) {
      stop("what should specify either Qball or ADC\n")
          }
  ngrad <- object@ngrad
  ddim <- object@ddim
  s0ind <- object@s0ind
  ns0 <- length(s0ind)
  sdcoef <- object@sdcoef
  if(all(sdcoef==0)) {
    cat("No parameters for model of error standard deviation found\n estimating these parameters\n You may prefer to run sdpar before calling dwiQball")
    sdcoef <- sdpar(object,interactive=FALSE)@sdcoef
  }
  z <- .Fortran("outlier",
                as.integer(object@si),
                as.integer(prod(ddim)),
                as.integer(ngrad),
                as.logical((1:ngrad)%in%s0ind),
                as.integer(ns0),
                si=integer(prod(ddim)*ngrad),
                index=integer(prod(ddim)),
                lindex=integer(1),
                DUPL=FALSE,
                PACKAGE="dti")[c("si","index","lindex")]
  si <- array(z$si,c(ddim,ngrad))
  index <- if(z$lindex>0) z$index[1:z$lindex] else numeric(0)
  rm(z)
  gc()
  if(what=="Qball"){
     ngrad0 <- ngrad - length(s0ind)
     s0 <- si[,,,s0ind]
     si <- si[,,,-s0ind]
     if(ns0>1) {
         dim(s0) <- c(prod(ddim),ns0)
         s0 <- s0 %*% rep(1/ns0,ns0)
         dim(s0) <- ddim
     }
     mask <- s0 > object@level
     mask <- connect.mask(mask)
     dim(s0) <- dim(si) <- NULL
     si[is.na(si)] <- 0
     si[(si == Inf)] <- 0
     si[(si == -Inf)] <- 0
     dim(si) <- c(prod(ddim),ngrad0)
     si <- t(si)
     cat("Data transformation completed ",date(),"\n")

     z <- design.spheven(order,object@gradient[,-s0ind],lambda)
     sphcoef <- z$matrix%*% si
     cat("Estimated coefficients for Q-ball (order=",order,") ",date(),"\n")

     res <- si - t(z$design) %*% sphcoef
     rss <- res[1,]^2
     for(i in 2:ngrad0) rss <- rss + res[i,]^2
     dim(rss) <- ddim
     sigma2 <- rss/(ngrad0-6)
     sphcoef[,!mask] <- 0
     dim(sphcoef) <- c((order+1)*(order+2)/2,ddim)
     dim(res) <- c(ngrad0,ddim)
     cat("Variance estimates generated ",date(),"\n")
     th0 <- array(s0,object@ddim)
     th0[!mask] <- 0
     gc()
  } else {
#  what == "ADC" 
     ngrad0 <- ngrad - length(s0ind)
     s0 <- si[,,,s0ind]
     si <- si[,,,-s0ind]
     if(ns0>1) {
         dim(s0) <- c(prod(ddim),ns0)
         s0 <- s0 %*% rep(1/ns0,ns0)
         dim(s0) <- ddim
     }
     mask <- s0 > object@level
     mask <- connect.mask(mask)
     dim(s0) <- dim(si) <- NULL
     si <- -log(si)
     si[is.na(si)] <- 0
     si[(si == Inf)] <- 0
     si[(si == -Inf)] <- 0
     dim(si) <- c(prod(ddim),ngrad0)
     si <- t(si)
     cat("Data transformation completed ",date(),"\n")

     z <- design.spheven(order,object@gradient[,-s0ind],lambda,plz=FALSE)
     sphcoef <- z$matrix%*% si
     cat("Estimated coefficients for ADC expansion in spherical harmonics (order=",order,") ",date(),"\n")

     res <- si - t(z$design) %*% sphcoef
     rss <- res[1,]^2
     for(i in 2:ngrad0) rss <- rss + res[i,]^2
     dim(rss) <- ddim
     sigma2 <- rss/(ngrad0-6)
     sphcoef[,!mask] <- 0
     dim(sphcoef) <- c((order+1)*(order+2)/2,ddim)
     dim(res) <- c(ngrad0,ddim)
     cat("Variance estimates generated ",date(),"\n")
     th0 <- array(s0,object@ddim)
     th0[!mask] <- 0
     gc()
  }
  lags <- c(5,5,3)
  scorr <- .Fortran("mcorr",as.double(res),
                   as.logical(mask),
                   as.integer(ddim[1]),
                   as.integer(ddim[2]),
                   as.integer(ddim[3]),
                   as.integer(ngrad0),
                   double(prod(ddim)),
                   double(prod(ddim)),
                   scorr = double(prod(lags)),
                   as.integer(lags[1]),
                   as.integer(lags[2]),
                   as.integer(lags[3]),
                   PACKAGE="dti",DUP=FALSE)$scorr
  dim(scorr) <- lags
  scorr[is.na(scorr)] <- 0
  cat("estimated spatial correlations",date(),"\n")
  cat("first order  correlation in x-direction",signif(scorr[2,1,1],3),"\n")
  cat("first order  correlation in y-direction",signif(scorr[1,2,1],3),"\n")
  cat("first order  correlation in z-direction",signif(scorr[1,1,2],3),"\n")

  scorr[is.na(scorr)] <- 0
  bw <- optim(c(2,2,2),corrrisk,method="L-BFGS-B",lower=c(.2,.2,.2),
  upper=c(3,3,3),lag=lags,data=scorr)$par
  bw[bw <= .25] <- 0
  cat("estimated corresponding bandwidths",date(),"\n")
  invisible(new("dwiQball",
                call  = args,
                order = as.integer(order),
                lambda = lambda,
                sphcoef = sphcoef,
                th0   = th0,
                sigma = sigma2,
                scorr = scorr, 
                bw = bw, 
                mask = mask,
                hmax = 1,
                gradient = object@gradient,
                btb   = object@btb,
                ngrad = object@ngrad, # = dim(btb)[2]
                s0ind = object@s0ind,
                replind = object@replind,
                ddim  = object@ddim,
                ddim0 = object@ddim0,
                xind  = object@xind,
                yind  = object@yind,
                zind  = object@zind,
                voxelext = object@voxelext,
                level = object@level,
                orientation = object@orientation,
                source = object@source,
                outlier = index,
                scale = 0.5,
                what = what)
            )
})

#
#
#

create.designmatrix.dti <- function(gradient, bvalue=1) {
  dgrad <- dim(gradient)
  if (dgrad[2]==3) gradient <- t(gradient)
  if (dgrad[1]!=3) stop("Not a valid gradient matrix")

  btb <- matrix(0,6,dgrad[2])
  btb[1,] <- gradient[1,]*gradient[1,]
  btb[4,] <- gradient[2,]*gradient[2,]
  btb[6,] <- gradient[3,]*gradient[3,]
  btb[2,] <- 2*gradient[1,]*gradient[2,]
  btb[3,] <- 2*gradient[1,]*gradient[3,]
  btb[5,] <- 2*gradient[2,]*gradient[3,]

  btb * bvalue
}


#
#
#

dtiIndices <- function(object, ...) cat("No DTI indices calculation defined for this class:",class(object),"\n")

setGeneric("dtiIndices", function(object, ...) standardGeneric("dtiIndices"))

setMethod("dtiIndices","dtiTensor",
function(object, which) {
  args <- sys.call(-1)
  args <- c(object@call,args)
  ddim <- object@ddim

  z <- .Fortran("dtiind3D",
                as.double(object@D),
                as.integer(object@ddim[1]),
                as.integer(object@ddim[2]),
                as.integer(object@ddim[3]),
                as.logical(object@mask),
                fa=double(prod(object@ddim)),
                ga=double(prod(object@ddim)),
                md=double(prod(object@ddim)),
                andir=double(3*prod(object@ddim)),
                bary=double(3*prod(object@ddim)),
                DUPL=FALSE,
                PACKAGE="dti")[c("fa","ga","md","andir","bary")]

  invisible(new("dtiIndices",
                call = args,
                fa = array(z$fa,object@ddim),
                ga = array(z$ga,object@ddim),
                md = array(z$md,object@ddim),
                andir = array(z$andir,c(3,object@ddim)),
                bary = array(z$bary,c(3,object@ddim)),
                gradient = object@gradient,
                btb   = object@btb,
                ngrad = object@ngrad, # = dim(btb)[2]
                s0ind = object@s0ind,
                ddim  = object@ddim,
                ddim0 = object@ddim0,
                voxelext = object@voxelext,
                orientation = object@orientation,
                xind  = object@xind,
                yind  = object@yind,
                zind  = object@zind,
                method = object@method,
                level = object@level,
                source= object@source)
            )
})

setMethod("[","dtiData",function(x, i, j, k, drop=FALSE){
  args <- sys.call(-1)
  args <- c(x@call,args)
  if (missing(i)) i <- TRUE
  if (missing(j)) j <- TRUE
  if (missing(k)) k <- TRUE
  if (is.logical(i)) ddimi <- x@ddim[1] else ddimi <- length(i)
  if (is.logical(j)) ddimj <- x@ddim[2] else ddimj <- length(j)
  if (is.logical(k)) ddimk <- x@ddim[3] else ddimk <- length(k)

  invisible(new("dtiData",
                call   = args,
                si     = x@si[i,j,k,,drop=FALSE],
                gradient = x@gradient,
                btb    = x@btb,
                ngrad  = x@ngrad,
                s0ind  = x@s0ind,
                replind = x@replind,
                ddim   = c(ddimi,ddimj,ddimk),
                ddim0  = x@ddim0,
                xind   = x@xind[i],
                yind   = x@yind[j],
                zind   = x@zind[k],
                sdcoef = x@sdcoef,
                level  = x@level,
                voxelext = x@voxelext,
                orientation = x@orientation,
                source = x@source)
            )
})

setMethod("[","dtiTensor",function(x, i, j, k, drop=FALSE){
  args <- sys.call(-1)
  args <- c(x@call,args)
  if (missing(i)) i <- TRUE
  if (missing(j)) j <- TRUE
  if (missing(k)) k <- TRUE
  if (is.logical(i)) ddimi <- x@ddim[1] else ddimi <- length(i)
  if (is.logical(j)) ddimj <- x@ddim[2] else ddimj <- length(j)
  if (is.logical(k)) ddimk <- x@ddim[3] else ddimk <- length(k)

  ind <- 1:prod(x@ddim)
  if(length(x@outlier)>0){
    ind <- rep(FALSE,prod(x@ddim))
    ind[x@outlier] <- TRUE
    dim(ind) <- x@ddim
    ind <- ind[i,j,k]
    outlier <- (1:length(ind))[ind]
  } else {
    outlier <- numeric(0)
  }

  invisible(new("dtiTensor",
                call  = args, 
                D     = x@D[,i,j,k,drop=FALSE],
                th0   = x@th0[i,j,k,drop=FALSE],
                sigma = if(x@method=="linear") x@sigma[i,j,k,drop=FALSE] else array(0,c(1,1,1)),
                scorr = x@scorr, 
                bw = x@bw,
                mask = x@mask[i,j,k,drop=FALSE],
                hmax = x@hmax,
                gradient = x@gradient,
                btb   = x@btb,
                ngrad = x@ngrad,
                s0ind = x@s0ind,
                replind = x@replind,
                ddim  = c(ddimi,ddimj,ddimk),
                ddim0 = x@ddim0,
                xind  = x@xind[i],
                yind  = x@yind[j],
                zind  = x@zind[k],
                voxelext = x@voxelext,
                level = x@level,
                orientation = x@orientation,
                outlier = outlier,
                scale = x@scale,
                source = x@source,
                method = x@method)
            )
})

setMethod("[","dtiIndices",function(x, i, j, k, drop=FALSE){
  args <- sys.call(-1)
  args <- c(x@call,args)
  if (missing(i)) i <- TRUE
  if (missing(j)) j <- TRUE
  if (missing(k)) k <- TRUE
  if (is.logical(i)) ddimi <- x@ddim[1] else ddimi <- length(i)
  if (is.logical(j)) ddimj <- x@ddim[2] else ddimj <- length(j)
  if (is.logical(k)) ddimk <- x@ddim[3] else ddimk <- length(k)

  invisible(new("dtiIndices",
                call = args,
                fa = x@fa[i,j,k,drop=FALSE],
                ga = x@ga[i,j,k,drop=FALSE],
                md = x@md[i,j,k,drop=FALSE],
                andir = x@andir[,i,j,k,drop=FALSE],
                bary = x@bary[,i,j,k,drop=FALSE],
                gradient = x@gradient,
                btb   = x@btb,
                ngrad = x@ngrad,
                s0ind = x@s0ind,
                ddim  = c(ddimi,ddimj,ddimk),
                ddim0 = x@ddim0,
                voxelext = x@voxelext,
                orientation = x@orientation,
                xind  = x@xind[i],
                yind  = x@yind[j],
                zind  = x@zind[k],
                method = x@method,
                level = x@level,
                source= x@source)
            )
})

setMethod("[","dwiQball",function(x, i, j, k, drop=FALSE){
  args <- sys.call(-1)
  args <- c(x@call,args)
  if (missing(i)) i <- TRUE
  if (missing(j)) j <- TRUE
  if (missing(k)) k <- TRUE
  if (is.logical(i)) ddimi <- x@ddim[1] else ddimi <- length(i)
  if (is.logical(j)) ddimj <- x@ddim[2] else ddimj <- length(j)
  if (is.logical(k)) ddimk <- x@ddim[3] else ddimk <- length(k)

  ind <- 1:prod(x@ddim)
  if(length(x@outlier)>0){
    ind <- rep(FALSE,prod(x@ddim))
    ind[x@outlier] <- TRUE
    dim(ind) <- x@ddim
    ind <- ind[i,j,k]
    outlier <- (1:length(ind))[ind]
  } else {
    outlier <- numeric(0)
  }

  invisible(new("dwiQball",
                call  = args, 
                order = x@order,
                lambda = x@lambda,
                sphcoef = x@sphcoef[,i,j,k,drop=FALSE],
                th0   = x@th0[i,j,k,drop=FALSE],
                sigma = x@sigma[i,j,k,drop=FALSE],
                scorr = x@scorr, 
                bw = x@bw,
                mask = x@mask[i,j,k,drop=FALSE],
                hmax = x@hmax,
                gradient = x@gradient,
                btb   = x@btb,
                ngrad = x@ngrad,
                s0ind = x@s0ind,
                replind = x@replind,
                ddim  = c(ddimi,ddimj,ddimk),
                ddim0 = x@ddim0,
                xind  = x@xind[i],
                yind  = x@yind[j],
                zind  = x@zind[k],
                voxelext = x@voxelext,
                level = x@level,
                orientation = x@orientation,
                outlier = outlier,
                scale = x@scale,
                source = x@source,
                what = x@what)
            )
})

extract <- function(x, ...) cat("Data extraction not defined for this class:",class(x),"\n")

setGeneric("extract", function(x, ...) standardGeneric("extract"))

setMethod("extract","dtiData",function(x, what="data", xind=TRUE, yind=TRUE, zind=TRUE){
  what <- tolower(what) 
  x <- x[xind,yind,zind]

  z <- list(NULL)
  if("gradient" %in% what) z$gradient <- x@gradient
  if("btb" %in% what) z$btb <- x@btb
  if("s0" %in% what) z$S0 <- x@si[,,,x@s0ind]
  if("sb" %in% what) z$Si <- x@si[,,,-x@s0ind]
  if("data" %in% what) z$data <- x@si
  invisible(z)
})

setMethod("extract","dtiTensor",function(x, what="tensor", xind=TRUE, yind=TRUE, zind=TRUE){
  what <- tolower(what) 

  x <- x[xind,yind,zind]
  n1 <- x@ddim[1]
  n2 <- x@ddim[2]
  n3 <- x@ddim[3]
  needev <- ("fa" %in% what) || ("ga" %in% what) || ("md" %in% what) || ("evalues" %in% what)
  needall <- needev && ("andir" %in% what)

  z <- list(NULL)
  if(needall){
    erg <- .Fortran("dti3Dall",
                    as.double(x@D),
                    as.integer(n1),
                    as.integer(n2),
                    as.integer(n3),
                    as.logical(x@mask),
                    fa=double(n1*n2*n3),
                    ga=double(n1*n2*n3),
                    md=double(n1*n2*n3),
                    andir=double(3*n1*n2*n3),
                    ev=double(3*n1*n2*n3),
                    DUPL=FALSE,
                    PACKAGE="dti")[c("fa","ga","md","andir","ev")]
    if("fa" %in% what) z$fa <- array(erg$fa,c(n1,n2,n3))
    if("ga" %in% what) z$ga <- array(erg$ga,c(n1,n2,n3))
    if("md" %in% what) z$md <- array(erg$md,c(n1,n2,n3))
    if("evalues" %in% what) z$evalues <- array(erg$ev,c(3,n1,n2,n3))
    if("andir" %in% what) z$andir <- array(erg$andir,c(3,n1,n2,n3))
  } else {
    if(needev){
      ev <- array(.Fortran("dti3Dev",
                           as.double(x@D),
                           as.integer(n1),
                           as.integer(n2),
                           as.integer(n3),
                           as.logical(x@mask),
                           ev=double(3*n1*n2*n3),
                           DUPL=FALSE,
                           PACKAGE="dti")$ev,c(3,n1,n2,n3))
      if("fa" %in% what) {
        dd <- apply(ev^2,2:4,sum)
        md <- (ev[1,,,]+ev[2,,,]+ev[3,,,])/3
        sev <- sweep(ev,2:4,md)
        z$fa <- sqrt(1.5*apply(sev^2,2:4,sum)/dd)
      }
      if("ga" %in% what) {
        sev <- log(ev)
        md <- (sev[1,,,]+sev[2,,,]+sev[3,,,])/3
        sev <- sweep(sev,2:4,md)
        ga <- sqrt(apply(sev^2,2:4,sum))
        ga[is.na(ga)] <- 0
        z$ga <- ga 
      }
      if("md" %in% what) z$md <- (ev[1,,,]+ev[2,,,]+ev[3,,,])/3
      if("evalues" %in% what) z$evalues <- ev
    }
    if("andir" %in% what){
      z$andir <- array(.Fortran("dti3Dand",
                                as.double(x@D),
                                as.integer(n1),
                                as.integer(n2),
                                as.integer(n3),
                                as.logical(x@mask),
                                andir=double(3*n1*n2*n3),
                                DUPL=FALSE,
                                PACKAGE="dti")$andir,c(3,n1,n2,n3))
    }
  }
  if("tensor" %in% what) z$tensor <- x@D
  if("s0" %in% what) z$s0 <- x@th0
  if("mask" %in% what) z$mask <- x@mask
  if("outlier" %in% what) {
    ind <- 1:prod(x@ddim)
    ind <- rep(FALSE,prod(x@ddim))
    if(length(x@outlier)>0) ind[x@outlier] <- TRUE
    dim(ind) <- x@ddim
  }
  invisible(z)
})

setMethod("extract","dtiIndices",function(x, what=c("fa","andir"), xind=TRUE, yind=TRUE, zind=TRUE){
  what <- tolower(what) 

  x <- x[xind,yind,zind]
  n1 <- x@ddim[1]
  n2 <- x@ddim[2]
  n3 <- x@ddim[3]

  z <- list(NULL)
  if("fa" %in% what) z$fa <- x@fa
  if("ga" %in% what) z$ga <- x@ga
  if("md" %in% what) z$md <- x@md
  if("andir" %in% what) z$andir <- x@andir
  if("bary" %in% what) z$bary <- x@bary
  invisible(z)
})

setMethod("extract","dwiQball",function(x, what="sphcoef", xind=TRUE, yind=TRUE, zind=TRUE){
  what <- tolower(what) 

  x <- x[xind,yind,zind]
  n1 <- x@ddim[1]
  n2 <- x@ddim[2]
  n3 <- x@ddim[3]

  z <- list(NULL)
  if("sphcoef" %in% what) z$sphcoef <- x@sphcoef
  if("s0" %in% what) z$s0 <- x@th0
  if("mask" %in% what) z$mask <- x@mask
  if("outlier" %in% what) {
    ind <- 1:prod(x@ddim)
    ind <- rep(FALSE,prod(x@ddim))
    if(length(x@outlier)>0) ind[x@outlier] <- TRUE
    dim(ind) <- x@ddim
  }
  invisible(z)
})

show3d <- function(obj,  ...) cat("3D Visualization not implemented for this class:",class(obj),"\n")

setGeneric("show3d", function(obj,  ...) standardGeneric("show3d"))

setMethod("show3d","dtiIndices",function(obj, index="FA", nx=NULL, ny=NULL, nz=NULL, center=NULL, method=1, level=0, bgcolor="black", add=FALSE, lwd=1,box=FALSE,title=FALSE,...){
  if(!require(rgl)) stop("Package rgl needs to be installed for 3D visualization")
  index <- tolower(index) 
  if(!(index%in%c("fa","ga"))) stop("index should be either 'FA' or 'GA'\n")
  if(is.null(center)) center <- floor(obj@ddim/2)
  if(is.null(nx)) nx <- obj@ddim[1]
  if(is.null(ny)) ny <- obj@ddim[2]
  if(is.null(nz)) nz <- obj@ddim[3]
  xind <- (center[1]-(nx%/%2)):(center[1]+(nx%/%2))
  yind <- (center[2]-(ny%/%2)):(center[2]+(ny%/%2))
  zind <- (center[3]-(nz%/%2)):(center[3]+(nz%/%2))
  xind <- xind[xind>0&xind<=obj@ddim[1]]
  yind <- yind[yind>0&yind<=obj@ddim[2]]
  zind <- zind[zind>0&zind<=obj@ddim[3]]
  n1 <- length(xind)
  n2 <- length(yind)
  n3 <- length(zind)
  n <- n1*n2*n3
  vext <- obj@voxelext
  ind <- switch(index,"fa"=obj@fa[xind,yind,zind], "ga"=obj@ga[xind,yind,zind])
  ind[ind<level] <- 0
  ind <- ind*min(vext)
  tmean <- array(0,c(3,n1,n2,n3))
  tmean[1,,,] <- xind*vext[1]
  tmean[2,,,] <- outer(rep(1,n1),yind)*vext[2]
  tmean[3,,,] <- outer(rep(1,n1),outer(rep(1,n2),zind))*vext[3]
  andir <- obj@andir[,xind,yind,zind]
  if(method==1) {
    andir <- abs(andir)
    dim(andir) <- c(3,n1*n2*n3)
  } else {
    ind1 <- andir[1,,]<0
    dim(andir) <- c(3,n1*n2*n3)
    andir[,ind1] <- - andir[,ind1]
    andir[2,] <- (1+andir[2,])/2
    andir[3,] <- (1+andir[3,])/2
  }
  colorvalues <- rgb(andir[1,],andir[2,],andir[3,])
  dim(andir) <- c(3,n1,n2,n3)
  andir <- sweep(andir,2:4,ind,"*")
  lcoord <- array(0,c(3,2,n1,n2,n3))
  lcoord[,1,,,] <-  andir/2+tmean[,,,]
  lcoord[,2,,,] <-  -andir/2+tmean[,,,]
  dim(lcoord) <- c(3,2*n1*n2*n3)
  lcoord <- cbind(lcoord)
  colorvalues <- c(rbind(colorvalues,colorvalues))
  if(!add) {
    open3d()
    par3d(...)
    rgl.bg(color=bgcolor)
  }
  rgl.lines(lcoord[1,],lcoord[2,],lcoord[3,],color=colorvalues,size=lwd)
  if(box) bbox3d()
  if(is.character(title)) {
     title3d(title,color="white",cex=1.5)
  } else {
     if(title) title3d("Main directions",color="white",cex=1.5)
  }
  cat("\n rgl-device",rgl.cur(),"Main directions of diffusion estimated from the tensor model\n\n")
  if(box) bbox3d()
  invisible(rgl.cur())
})
setMethod("show3d","dtiTensor", function(obj,nx=NULL,ny=NULL,nz=NULL,center=NULL,method=1,level=0,scale=.5,bgcolor="black",add=FALSE,subdivide=2,maxobjects=729,what="ADC",minalpha=.25,normalize=NULL,box=FALSE,title=FALSE,...){
  if(!require(rgl)) stop("Package rgl needs to be installed for 3D visualization")
  if(!exists("icosa0")) data("polyeders")
  if(subdivide<0||subdivide>4) subdivide <- 3
  if(is.null(nx)) nx <- obj@ddim[1]
  if(is.null(ny)) ny <- obj@ddim[2]
  if(is.null(nz)) nz <- obj@ddim[3]
  n <- nx*ny*nz
  if(is.null(center)) center <- floor(obj@ddim/2)
  if(nx*ny*nz>maxobjects) {
  cat("size of data cube",n," exceeds maximum of",maxobjects,"\n")
  if(nz > maxobjects^(1/3)) n3 <- 1 else n3 <- nz
    n1 <- n2 <- floor(sqrt(maxobjects/n3))
  } else {
    n1 <- nx
    n2 <- ny
    n3 <- nz
  }
  xind <- (center[1]-(n1%/%2)):(center[1]+(n1%/%2))
  yind <- (center[2]-(n2%/%2)):(center[2]+(n2%/%2))
  zind <- (center[3]-(n3%/%2)):(center[3]+(n3%/%2))
  xind <- xind[xind>0&xind<=obj@ddim[1]]
  yind <- yind[yind>0&yind<=obj@ddim[2]]
  zind <- zind[zind>0&zind<=obj@ddim[3]]
  n1 <- length(xind)
  n2 <- length(yind)
  n3 <- length(zind)
  n <- n1*n2*n3
  if(n==0) stop("Empty cube specified")
  cat(" selected cube specified by \n xind=",min(xind),":",max(xind),
      "\n yind=",min(yind),":",max(yind),
      "\n zind=",min(zind),":",max(zind),"\n")
  obj <- obj[xind,yind,zind]
  vext <- obj@voxelext
  center <- center*vext
  D <- obj@D
  D <- D/max(D)
  dim(D) <- c(6,n)
  indpos <- (1:n)[D[1,]*D[4,]*D[6,]>0]
  tens <- D[,indpos]
  tmean <- array(0,c(3,n1,n2,n3))
  tmean[1,,,] <- xind*vext[1]
  tmean[2,,,] <- outer(rep(1,n1),yind)*vext[2]
  tmean[3,,,] <- outer(rep(1,n1),outer(rep(1,n2),zind))*vext[3]
  dim(tmean) <- c(3,n)
  tmean <- tmean[,indpos]
  z <- extract(obj,what=c("andir","fa"))
  maxev <- extract(obj,what="evalues")$evalues[3,,,]
  maxev <- maxev[indpos]
  andir <- z$andir
  dim(andir) <- c(3,n1*n2*n3)
  andir <- andir[,indpos]
  fa <- z$fa[indpos]
  mask <- obj@mask[indpos]
  n <- length(indpos)
  if(method==1) {
    andir <- abs(andir)
  } else {
    ind<-andir[1,]<0
    andir[,ind] <- - andir[,ind]
    andir[2,] <- (1+andir[2,])/2
    andir[3,] <- (1+andir[3,])/2
  }
  colorvalues <- rgb(andir[1,],andir[2,],andir[3,])
  dim(tens) <- c(6,n)
  if(level>0){
    indpos <- (1:n)[(fa>level)&mask]
    tens <- tens[,indpos]
    tmean <- tmean[,indpos]
    colorvalues <- colorvalues[indpos]
    fa <- fa[indpos]
    maxev <- maxev[indpos]
    n <- length(indpos)
  }
  if(is.null(normalize)) normalize <- switch(tolower(what),"tensor"=FALSE,"adc"=TRUE)
  polyeder <- switch(subdivide+1,icosa0,icosa1,icosa2,icosa3,icosa4)
  radii <- .Fortran(switch(tolower(what),"tensor"="ellradii","adcradii"),
                    as.double(polyeder$vertices),
                    as.integer(polyeder$nv),
                    as.double(tens),
                    as.integer(n),
                    as.double(scale/2),
                    radii=double(n*polyeder$nv),
                    DUPL=FALSE,
                    PACKAGE="dti")$radii
  dim(radii) <- c(polyeder$nv,n)
  if(normalize){
     minradii <- apply(radii,2,min)
     maxradii <- apply(radii,2,max)
     radii <- sweep(radii,2,minradii,"-")
     radii <- sweep(radii,2,maxradii-minradii,"/")*scale
  } else {
  radii <- radii/max(radii)*scale
  }
  if(!add) {
     rgl.open()
     par3d(...)
     rgl.bg(color=bgcolor)
     }
  show3d.tens(radii,polyeder,centers=tmean,colors=colorvalues,alpha=minalpha+(1-minalpha)*fa)
  if(box) bbox3d()
  if(is.character(title)) {
     title3d(title,color="white",cex=1.5)
  } else {
     if(title) title3d(switch(tolower(what),"tensor"="estimated tensors","adc"="estimated ADC (tensor)"),color="white",cex=1.5)
  }
  cat("\n rgl-device",rgl.cur(),switch(tolower(what),"tensor"="estimated tensors","adc"="apparent diffusion coefficients from estimated tensors"),"\n",
  if(obj@hmax>1) paste("smoothed with hmax=",obj@hmax),if(normalize) "normalized","\n")
  invisible(rgl.cur())
})
setMethod("show3d","dtiData", function(obj,nx=NULL,ny=NULL,nz=NULL,center=NULL,scale=.5,bgcolor="black",add=FALSE,maxobjects=729,what="ADC",minalpha=1,power=1,nn=1,normalize=FALSE,box=FALSE,title=FALSE,...){
  if(!require(rgl)) stop("Package rgl needs to be installed for 3D visualization")
  if(is.null(nx)) nx <- obj@ddim[1]
  if(is.null(ny)) ny <- obj@ddim[2]
  if(is.null(nz)) nz <- obj@ddim[3]
  n <- nx*ny*nz
  if(is.null(center)) center <- floor(obj@ddim/2)
  if(nx*ny*nz>maxobjects) {
  cat("size of data cube",n," exceeds maximum of",maxobjects,"\n")
  if(nz > maxobjects^(1/3)) n3 <- 1 else n3 <- nz
    n1 <- n2 <- floor(sqrt(maxobjects/n3))
  } else {
    n1 <- nx
    n2 <- ny
    n3 <- nz
  }
  xind <- (center[1]-(n1%/%2)):(center[1]+(n1%/%2))
  yind <- (center[2]-(n2%/%2)):(center[2]+(n2%/%2))
  zind <- (center[3]-(n3%/%2)):(center[3]+(n3%/%2))
  xind <- xind[xind>0&xind<=obj@ddim[1]]
  yind <- yind[yind>0&yind<=obj@ddim[2]]
  zind <- zind[zind>0&zind<=obj@ddim[3]]
  n1 <- length(xind)
  n2 <- length(yind)
  n3 <- length(zind)
  n <- n1*n2*n3
  if(n==0) stop("Empty cube specified")
  cat(" selected cube specified by \n xind=",min(xind),":",max(xind),
      "\n yind=",min(yind),":",max(yind),
      "\n zind=",min(zind),":",max(zind),"\n")
  obj <- obj[xind,yind,zind]
  vext <- obj@voxelext
  tmean <- array(0,c(3,n1,n2,n3))
  tmean[1,,,] <- xind*vext[1]
  tmean[2,,,] <- outer(rep(1,n1),yind)*vext[2]
  tmean[3,,,] <- outer(rep(1,n1),outer(rep(1,n2),zind))*vext[3]
  dim(tmean) <- c(3,n)
  radii <- extract(obj,"sb")$Si
  s0 <- extract(obj,"S0")$S0
  if(length(dim(s0))==4) s0 <- apply(s0,1:3,mean)
  radii <- sweep(radii,1:3,s0,"/")
  if(what=="ADC") radii <- -log(radii)
  ngrad <- dim(radii)[length(dim(radii))]
  dim(radii) <- c(length(radii)/ngrad,ngrad)
  radii <- t(radii)
  sscale <- scale
  if(what=="colorcoded") sscale <- 1
  if(normalize){
     minradii <- apply(radii,2,min)
     maxradii <- apply(radii,2,max)
     radii <- sweep(radii,2,minradii,"-")
     radii <- sweep(radii,2,maxradii-minradii,"/")^power*sscale
  } else {
     radii <- radii/max(radii)*sscale
  }
  gradient <- obj@gradient[,-obj@s0ind]
  if(!add) {
     rgl.open()
     par3d(...)
     rgl.bg(color=bgcolor)
     }
  if(what=="colorcoded") {
     polyeder <- switch(subdivide+1,icosa0,icosa1,icosa2,icosa3,icosa4)
     ngrad <- dim(gradient)[2]
     n <- dim(radii)[2]
  cat("radii",dim(radii))
     radii <- matrix(.Fortran("datinter",
                        as.double(radii),
                        as.integer(n),
                        as.double(gradient),
                        as.integer(ngrad),
                        as.double(polyeder$vertices),
                        as.integer(polyeder$nv),
                        as.integer(nn),#number of nearest neighbors
                        double(nn),#auxiliary 
                        integer(nn),#auxiliary 
                        polyradii=double(polyeder$nv*n),
                        DUPL=FALSE,
                        PACKAGE="dti")$polyradii,polyeder$nv,n)
  cat("newradii",dim(radii))
  show3d.cdata(radii,polyeder,centers=tmean,minalpha=minalpha,scale=scale,...)
  } else {
  show3d.data(radii,gradient,centers=tmean,minalpha=minalpha,...)
  }
  if(box) bbox3d()
  if(is.character(title)) {
     title3d(title,color="white",cex=1.5)
  } else {
     if(title) title3d(switch(tolower(what),"data"="observed DWI data","adc"="observed ADC"),color="white",cex=1.5)
  }
  cat("\n rgl-device",rgl.cur(),switch(tolower(what),"data"="observed diffusion weighted data","adc"="apparent diffusion coefficients from data"),"\n",
  if(normalize) "normalized","\n")
  invisible(rgl.cur())
})
setMethod("show3d","dwiQball", function(obj,nx=NULL,ny=NULL,nz=NULL,center=NULL,scale=0.5,bgcolor="black",add=FALSE,subdivide=3,maxobjects=729,minalpha=1,power=1,normalize=TRUE,box=FALSE,title=FALSE,...){
  if(!require(rgl)) stop("Package rgl needs to be installed for 3D visualization")
  if(!exists("icosa0")) data("polyeders")
  if(subdivide<0||subdivide>4) subdivide <- 3
  if(is.null(nx)) nx <- obj@ddim[1]
  if(is.null(ny)) ny <- obj@ddim[2]
  if(is.null(nz)) nz <- obj@ddim[3]
  n <- nx*ny*nz
  if(is.null(center)) center <- floor(obj@ddim/2)
  if(nx*ny*nz>maxobjects) {
  cat("size of data cube",n," exceeds maximum of",maxobjects,"\n")
  if(nz > maxobjects^(1/3)) n3 <- 1 else n3 <- nz
    n1 <- n2 <- floor(sqrt(maxobjects/n3))
  } else {
    n1 <- nx
    n2 <- ny
    n3 <- nz
  }
  xind <- (center[1]-(n1%/%2)):(center[1]+(n1%/%2))
  yind <- (center[2]-(n2%/%2)):(center[2]+(n2%/%2))
  zind <- (center[3]-(n3%/%2)):(center[3]+(n3%/%2))
  xind <- xind[xind>0&xind<=obj@ddim[1]]
  yind <- yind[yind>0&yind<=obj@ddim[2]]
  zind <- zind[zind>0&zind<=obj@ddim[3]]
  n1 <- length(xind)
  n2 <- length(yind)
  n3 <- length(zind)
  n <- n1*n2*n3
  if(n==0) stop("Empty cube specified")
  cat(" selected cube specified by \n xind=",min(xind),":",max(xind),
      "\n yind=",min(yind),":",max(yind),
      "\n zind=",min(zind),":",max(zind),"\n")
  obj <- obj[xind,yind,zind]
  vext <- obj@voxelext
  center <- center*vext
  sphcoef <- obj@sphcoef
  dim(sphcoef) <- c(dim(sphcoef)[1],prod(dim(sphcoef)[-1]))
  tmean <- array(0,c(3,n1,n2,n3))
  tmean[1,,,] <- xind*vext[1]
  tmean[2,,,] <- outer(rep(1,n1),yind)*vext[2]
  tmean[3,,,] <- outer(rep(1,n1),outer(rep(1,n2),zind))*vext[3]
  dim(tmean) <- c(3,n)
  polyeder <- switch(subdivide+1,icosa0,icosa1,icosa2,icosa3,icosa4)
  sphdesign <- design.spheven(obj@order,polyeder$vertices,obj@lambda,smatrix=FALSE)$design
  radii <- t(sphdesign)%*%sphcoef
  if(normalize){
     minradii <- apply(radii,2,min)
     maxradii <- apply(radii,2,max)
     radii <- sweep(radii,2,minradii,"-")
     radii <- sweep(radii,2,maxradii-minradii,"/")^power*scale

  } else {
  radii <- radii/max(radii)*scale
  }
  if(!add) {
     rgl.open()
     par3d(...)
     rgl.bg(color=bgcolor)
  }
  show3d.odf(radii,polyeder,centers=tmean,minalpha=minalpha,...)
  if(box) bbox3d()
  if(is.character(title)) {
     title3d(title,color="white",cex=1.5)
  } else {
     if(title) title3d(switch(tolower(obj@what),"qball"="ODF (Qball)","adc"="ADC (Sph. Harmonics)"),color="white",cex=1.5)
  }
  cat("\n rgl-device",rgl.cur(),switch(tolower(obj@what),"qball"="Estimated orientation density function (Qball)","adc"="estimated apparent diffusion coefficients (sperical harmonics"),"\n",
  if(normalize) "normalized","\n")
  invisible(rgl.cur())
})


