% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcaRel.R
\name{bcaRel}
\alias{bcaRel}
\title{Representation of a mass function in a product space}
\usage{
bcaRel(
  tt,
  spec,
  infovar,
  varnames,
  valuenames,
  relnb = NULL,
  infovarnames,
  infovaluenames
)
}
\arguments{
\item{tt}{The description matrix of the subsets establishing the relation. This matrix is obtained by putting the variables side by side, as in a truth table representation. For each variable, there are as many columns as possible values. Each row of the matrix is an element of a subset. Each element is described by a sequence of 0 (absence of value of a variable) or 1 (presence of value). This forms a complete disjunctive coding.}

\item{spec}{A two column matrix. First column: numbers assigned to the sub-assemblies. Second column: the mass values of the sub-assemblies. If the subset has more than one element, the number of the subset and its associated mass value are repeated to match the number of elements in the subset.}

\item{infovar}{A two column matrix containing variable identification numbers and the number of elements of each variable. The identification numbers must be ordered in increasing number.}

\item{varnames}{The names of the variables.}

\item{valuenames}{A list of the names of the variables with the name of the elements of their frame of discernment.}

\item{relnb}{A number given to the relation. Set at 0 if omitted.}

\item{infovarnames}{Deprecated. Old name for \code{varnames}.}

\item{infovaluenames}{Deprecated. Old name for \code{valuenames}.}
}
\value{
An object of class \code{bcaspec} called a bca for "basic chance assignment". This is a list containing the following components:  \itemize{
\item con The measure of conflict.
\item tt The resulting table of subsets. Rownames of the matrix of subsets are generated from the column names of the elements of the product frame. See \code{\link{nameRows}} for details.
\item spec The resulting two-column matrix of specification numbers with associated mass values.
\item infovar The two-column matrix of variables number and size given in the input data.
\item valuenames A list of the names of the variables with the name of the elements of their frame of discernment.
\item inforel A two-column matrix containing the relation number and the depth (number of variables) of the relation.
}
}
\description{
This function is used to represent a relation between two or more variables in their product space \code{P}. The relation can be described by more than one subset of \code{P}. Each subset can also  include more than one element. Complete disjunctive coding is used to represent one element in the input matrix of the function.
}
\examples{
# A logical implication rule
# A typical relation between two variables is the
# logical implication a -> b. Let us suppose
# that a stands for Rain: {yes, no} and b stands for
# Roadworks: {yes, no}. From experience,
# I am 75 \% sure that there will be RoadWorks if there is no rain.

 # 1. The tt table of the logical implication
 ttrwf <- matrix(c(0,1,1,0,1,0,1,0,1,0,0,1,1,1,1,1),
 nrow = 4, byrow = TRUE, 
 dimnames = list(NULL, c("rWdy", "rWdn", "Ry", "Rn")) )
 
 # 2. The mass distribution
 specrw <-  matrix(c(1,1,1,2,0.75,0.75,0.75,0.25), ncol = 2, 
 dimnames = list(NULL, c("specnb", "mass")))
  
 # 3. Variables numbers and sizes
 inforw <- matrix(c(4,5,2,2), ncol = 2, 
 dimnames = list(NULL, c("varnb", "size")) )
bcaRel(tt = ttrwf, spec = specrw, infovar = inforw,
 varnames = c("RdWorks", "Rain"), relnb = 6)

}
\author{
Claude Boivin
}
