% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score-permutations.R
\name{score_rue}
\alias{score_rue}
\title{Predict Resampling Uncertainty (Prediction Confidence)}
\usage{
score_rue(x_train, x_test, n_trees = 500L, response_name = "label")
}
\arguments{
\item{x_train}{Training (reference) sample.}

\item{x_test}{Test sample.}

\item{n_trees}{The number of trees in random forest.}

\item{response_name}{The column name of the categorical outcome to predict.}
}
\value{
A named list or object of class \code{outlier.test} containing:
\itemize{
   \item \code{train}: vector of scores in training set
   \item \code{test}: vector of scores in test set
}
}
\description{
Estimate prediction uncertainty using random forest with the \pkg{ranger}
package. The prefix \emph{rue} stands for resampling uncertainty estimation,
the relevant notion of outlyingness. This function is useful to test for
dataset shift via prediction uncertainty from supervised algorithms.
}
\details{
\code{score_rue} first fits to the training data and uses out-of-bag
predictions to estimate prediction uncertainty for this reference
sample. Then it leverages out-of-sample predictions to do the same for
the test set. As a result, estimating p-value via permutations does not
require refitting the algorithm for every permutation.
}
\section{Notes}{

For prediction uncertainty, we essentially implement the approach in
Schulam & Saria (2019) with random forest. The standard errors of the mean
predictions are the outlier scores. Any performant method for
confidence-based out-of-distribution (OOD) detection can replace random
forest. Berger et al. (2021) compares methods for confidence-based OOD
detection.
}

\examples{
\donttest{
library(dsos)
set.seed(12345)
data(iris)
idx <- sample(nrow(iris), 2 / 3 * nrow(iris))
xy_train <- iris[idx, ]
xy_test <- iris[-idx, ]
outlier_scores <- score_rue(xy_train, xy_test, response_name = "Species")
str(outlier_scores)
}

}
\references{
Schulam, P., & Saria, S. (2019, April).
\emph{Can you trust this prediction? Auditing pointwise reliability after learning}.
In The 22nd International Conference on Artificial Intelligence and Statistics (pp. 1022-1031).
PMLR.

Berger, C., Paschali, M., Glocker, B., & Kamnitsas, K. (2021).
\emph{Confidence-based out-of-distribution detection: a comparative study and analysis}.
In Uncertainty for Safe Utilization of Machine Learning in Medical Imaging, and Perinatal Imaging, Placental and Preterm Image Analysis (pp. 122-132).
Springer, Cham.
}
\seealso{
Other scoring: 
\code{\link{score_cp}()},
\code{\link{score_od}()},
\code{\link{score_rd}()}
}
\concept{scoring}
