% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds.group_by.R
\name{ds.group_by}
\alias{ds.group_by}
\title{Group by one or more variables}
\usage{
ds.group_by(
  df.name = NULL,
  tidy_expr,
  .add = FALSE,
  .drop = TRUE,
  newobj = NULL,
  datasources = NULL
)
}
\arguments{
\item{df.name}{Character specifying a serverside data frame or tibble.}

\item{tidy_expr}{List of variables or computations to group by.}

\item{.add}{When FALSE, the default, \code{group_by()} will override existing groups. To add to the
existing groups, use .add = TRUE.}

\item{.drop}{Drop groups formed by factor levels that don't appear in the data? The default is
TRUE except when .data has been previously grouped with .drop = FALSE.}

\item{newobj}{Character specifying name for new server-side data frame.}

\item{datasources}{DataSHIELD connections object.}
}
\value{
No return value, called for its side effects. A grouped data frame with class grouped_df
\code{newobj} is created on the server, unless the combination of \code{tidy_expr} and \code{.add}
yields a empty set of grouping columns, in which case a tibble will be created on the server.
}
\description{
DataSHIELD implentation of \code{dplyr::group_by}.
}
\examples{
\dontrun{
ds.group_by(
  df.name = "mtcars",
  expr = list(mpg, cyl),
  newobj = "grouped_df"
)
}
}
