% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_util_fun.R
\name{chars_to_text}
\alias{chars_to_text}
\alias{vec2str}
\title{Combine character inputs \code{x} into a single string of text.}
\usage{
chars_to_text(x, sep = "")
}
\arguments{
\item{x}{A vector (required), typically a character vector.}

\item{sep}{Character to insert between the elements 
of a multi-element character vector as input \code{x}? 
Default: \code{sep = ""} (i.e., add nothing).}
}
\value{
A character vector (of length 1).
}
\description{
\code{chars_to_text} combines multi-element character inputs \code{x} 
into a single string of text (i.e., a character object of length 1), 
while preserving punctuation and spaces.
}
\details{
\code{chars_to_text} is an inverse function of \code{\link{text_to_chars}}. 

Note that using \code{paste(x, collapse = "")} would remove spaces. 
See \code{\link{collapse_chars}} for a simpler alternative.
}
\examples{
# (a) One string (with spaces and punctuation):
t1 <- "Hello world! This is _A   TEST_. Does this work?"
(cv <- unlist(strsplit(t1, split = "")))
(t2 <- chars_to_text(cv))
t1 == t2

# (b) Multiple strings (nchar from 0 to >1):
s <- c("Hi", " ", "", "there!", " ", "", "Does  THIS  work?")
chars_to_text(s)

# Note: Using sep argument: 
chars_to_text(c("Hi there!", "How are you today?"), sep = "  ")
chars_to_text(1:3, sep = " | ")
 
}
\seealso{
\code{\link{collapse_chars}} for collapsing character vectors; 
\code{\link{text_to_chars}} for splitting text into a vector of characters; 
\code{\link{text_to_words}} for splitting text into a vector of words; 
\code{\link{strsplit}} for splitting strings.

Other text objects and functions: 
\code{\link{Umlaut}},
\code{\link{capitalize}()},
\code{\link{caseflip}()},
\code{\link{cclass}},
\code{\link{collapse_chars}()},
\code{\link{count_chars_words}()},
\code{\link{count_chars}()},
\code{\link{count_words}()},
\code{\link{invert_rules}()},
\code{\link{l33t_rul35}},
\code{\link{map_text_chars}()},
\code{\link{map_text_coord}()},
\code{\link{map_text_regex}()},
\code{\link{metachar}},
\code{\link{read_ascii}()},
\code{\link{text_to_chars}()},
\code{\link{text_to_sentences}()},
\code{\link{text_to_words}()},
\code{\link{transl33t}()},
\code{\link{words_to_text}()}
}
\concept{text objects and functions}
