% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{reliability}
\alias{reliability}
\title{Reliability function}
\usage{
reliability(
  x,
  k1 = 0L,
  k2,
  upstates,
  output_file = NULL,
  plot = FALSE,
  ncpu = 2
)
}
\arguments{
\item{x}{An object of class \code{dmm}}

\item{k1}{Start position (default value=0) :  a positive integer giving the start position along the sequence from which the reliabilities of the DMM should be computed, such that \code{k1}<\code{k2}}

\item{k2}{End position :  a positive integer giving the end position along the sequence until which the reliabilities of the DMM should be computed, such that \code{k2}>\code{k1}}

\item{upstates}{Character vector of the subspace working states among the state space vector such that upstates < s}

\item{output_file}{(Optional) A file containing matrix of reliability probabilities (e.g, "C:/.../REL.txt")}

\item{plot}{\code{FALSE} (default); \code{TRUE} (display a figure plot of reliability probabilities by position)}

\item{ncpu}{Default=2. Represents the number of cores used to parallelized computation. If ncpu=-1, then it uses all available cores.}
}
\value{
A vector of length k + 1 giving the values of the reliability for the period \eqn{[0 \ldots k]}
}
\description{
Reliability or the survival function of a system at time \eqn{k \in N}
}
\details{
The reliability at time \eqn{k \in N} is the probability that the system has functioned without failure in the period \eqn{[0, k]}
}
\examples{
data(lambda, package = "drimmR")
dmm <- fitdmm(lambda, 1, 1, c('a','c','g','t'), init.estim = "freq",
fit.method="sum")
k1 <- 1
k2 <- 200
upstates <- c("c","t")  # vector of working states
reliability(dmm,k1,k2,upstates,plot=TRUE)
}
\references{
\insertRef{BaVe2018}{drimmR}
}
\seealso{
\link[drimmR]{fitdmm}, \link[drimmR]{getTransitionMatrix}
}
\author{
Alexandre Seiller
}
