% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nwalksom.R
\name{netstats_om_nwalks}
\alias{netstats_om_nwalks}
\title{Compute the Number of Walks of Length K in a One-Mode Network}
\usage{
netstats_om_nwalks(net, k)
}
\arguments{
\item{net}{An unweighted one-mode network adjacency matrix.}

\item{k}{A numerical value that corresponds to the length of the paths to be computed.}
}
\value{
An \emph{n} x \emph{n} matrix of counts of paths.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This function calculates the number of walks of length \emph{k}
between any two vertices in an unweighted one-mode network.
}
\details{
A nice result from graph theory is that the number of walks of length \emph{k} between
vertices \emph{i} and \emph{j} can be found by:
\deqn{ A_{ij}^k }

This function assumes that there are no self-loops (i.e., the diagonal of the matrix is 0).
}
\examples{

# For this example, we generate a random one-mode graph with the sna package.
#creating the random network with 10 actors
set.seed(9999)
rnet <- matrix(sample(c(0,1), 10*10, replace = TRUE, prob = c(0.8,0.2)),
               nrow = 10, ncol = 10, byrow = TRUE)
diag(rnet) <- 0 #setting self ties to 0
#counting the walks of length 2
netstats_om_nwalks(rnet, k = 2)
#counting the walks of length 5
netstats_om_nwalks(rnet, k = 5)
}
\author{
Kevin A. Carson \href{mailto:kacarson@arizona.edu}{kacarson@arizona.edu}, Diego F. Leal \href{mailto:dflc@arizona.edu}{dflc@arizona.edu}
}
