% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-usedrake.R
\name{use_drake}
\alias{use_drake}
\title{Use drake in a project}
\usage{
use_drake(open = interactive())
}
\arguments{
\item{open}{Logical, whether to open \code{make.R} for editing.}
}
\description{
Add top-level R script files to use \code{drake}
in your data analysis project. For details, read
\url{https://ropenscilabs.github.io/drake-manual/projects.html}
}
\details{
Files written:
\enumerate{
\item \code{make.R}: a suggested master R script for batch mode.
\item \code{_drake.R}: a configuration R script for
the \href{https://ropensci.github.io/drake/reference/r_make.html}{r_*()} functions documented at # nolint
\url{https://ropenscilabs.github.io/drake-manual/projects.html#safer-interactivity}. # nolint
Remarks:
}
\itemize{
\item There is nothing magical about the name, \code{make.R}.
You can call it whatever you want.
\item Other supporting scripts, such as \code{R/packages.R},
\code{R/functions.R}, and \code{R/plan.R}, are not included.
\item You can find examples at
\url{https://github.com/wlandau/drake-examples}
and download examples with \code{\link[=drake_example]{drake_example()}}
(e.g. \code{drake_example("main")}).
}
}
\examples{
\dontrun{
# use_drake(open = FALSE) # nolint
}
}
