% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drake_plan_keywords.R
\name{file_in}
\alias{file_in}
\title{Declare input files and directories.}
\usage{
file_in(...)
}
\arguments{
\item{...}{Character vector, paths to files and directories.}
}
\value{
A character vector of declared input file or directory paths.
}
\description{
\code{file_in()} marks individual files
(and whole directories) that your targets depend on.
}
\details{
As of \code{drake} 7.4.0, \code{file_in()} and \code{file_out()} have
experimental support for URLs. If the file name begins with
"http://", "https://", or "ftp://", \code{\link[=make]{make()}} attempts
to check the ETag to see if the data changed from last time.
If no ETag can be found, \code{drake} simply uses the ETag
from last \code{\link[=make]{make()}} and registers the file as unchanged
(which prevents your workflow from breaking if you lose
internet access). If this approach to tracking remote data
does not work for you, consider a custom trigger:
\url{https://ropenscilabs.github.io/drake-manual/triggers.html}.
}
\section{Keywords}{

\code{\link[=drake_plan]{drake_plan()}} understands special keyword functions for your commands.
With the exception of \code{\link[=target]{target()}}, each one is a proper function
with its own help file.
\itemize{
\item \code{\link[=target]{target()}}: declare more than just the command,
e.g. assign a trigger or transform.
Examples: \url{https://ropenscilabs.github.io/drake-manual/plans.html#large-plans}. # nolint
\item \code{\link[=file_in]{file_in()}}: declare an input file dependency.
\item \code{\link[=file_out]{file_out()}}: declare an output file to be produced
when the target is built.
\item \code{\link[=knitr_in]{knitr_in()}}: declare a \code{knitr} file dependency such as an
R Markdown (\code{*.Rmd}) or R LaTeX (\code{*.Rnw}) file.
\item \code{\link[=ignore]{ignore()}}: force \code{drake} to entirely ignore a piece of code:
do not track it for changes and do not analyze it for dependencies.
\item \code{\link[=no_deps]{no_deps()}}: tell \code{drake} to not track the dependencies
of a piece of code. \code{drake} still tracks the code itself for changes.
\item \code{\link[=drake_envir]{drake_envir()}}: get the environment where drake builds targets.
Intended for advanced custom memory management.
}
}

\examples{
\dontrun{
isolate_example("contain side effects", {
# The `file_out()` and `file_in()` functions
# just takes in strings and returns them.
file_out("summaries.txt")
# Their main purpose is to orchestrate your custom files
# in your workflow plan data frame.
plan <- drake_plan(
  out = write.csv(mtcars, file_out("mtcars.csv")),
  contents = read.csv(file_in("mtcars.csv"))
)
plan
# drake knows "\\"mtcars.csv\\"" is the first target
# and a dependency of `contents`. See for yourself:

make(plan)
file.exists("mtcars.csv")

# You can also work with entire directories this way.
# However, in `file_out("your_directory")`, the directory
# becomes an entire unit. Thus, `file_in("your_directory")`
# is more appropriate for subsequent steps than
# `file_in("your_directory/file_inside.txt")`.
plan <- drake_plan(
  out = {
    dir.create(file_out("dir"))
    write.csv(mtcars, "dir/mtcars.csv")
  },
  contents = read.csv(file.path(file_in("dir"), "mtcars.csv"))
)
plan

make(plan)
file.exists("dir/mtcars.csv")

# See the connections that the file relationships create:
config <- drake_config(plan)
vis_drake_graph(config)
})
}
}
\seealso{
\code{\link[=file_out]{file_out()}}, \code{\link[=knitr_in]{knitr_in()}}, \code{\link[=ignore]{ignore()}}, \code{\link[=no_deps]{no_deps()}}
}
