% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean.R
\name{which_clean}
\alias{which_clean}
\title{Which targets will \code{clean()} invalidate?
\lifecycle{stable}}
\usage{
which_clean(
  ...,
  list = character(0),
  path = NULL,
  cache = drake::drake_cache(path = path)
)
}
\arguments{
\item{...}{Targets to remove from the cache: as names (symbols) or
character strings. If the \code{tidyselect} package is installed,
you can also supply \code{dplyr}-style \code{tidyselect}
commands such as \code{starts_with()}, \code{ends_with()}, and \code{one_of()}.}

\item{list}{Character vector naming targets to be removed from the
cache. Similar to the \code{list} argument of \code{\link[=remove]{remove()}}.}

\item{path}{Path to a \code{drake} cache
(usually a hidden \verb{.drake/} folder) or \code{NULL}.}

\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} is ignored.}
}
\description{
\code{which_clean()} is a safety check for \code{clean()}.
It shows you the targets that \code{clean()} will
invalidate (or remove if \code{garbage_collection} is \code{TRUE}).
It helps you avoid accidentally removing targets you care about.
}
\examples{
\dontrun{
isolate_example("Quarantine side effects.", {
plan <- drake_plan(x = 1, y = 2, z = 3)
make(plan)
cached()
which_clean(x, y) # [1] "x" "y"
clean(x, y)       # Invalidates targets x and y.
cached()          # [1] "z"
})
}
}
\seealso{
\code{\link[=clean]{clean()}}
}
