% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workplan.R
\name{ignore}
\alias{ignore}
\title{Ignore components of commands and imported functions.}
\usage{
ignore(x = NULL)
}
\arguments{
\item{x}{code to ignore}
}
\value{
the argument
}
\description{
In a command in the workflow plan
or the body of an imported function, you can
\code{ignore(some_code)} to
\enumerate{
\item Force \code{drake} to not track dependencies in \code{some_code}, and
\item Ignore any changes in \code{some_code} when it comes to
deciding which target are out of date.
}
}
\examples{
\dontrun{
test_with_dir("Contain side effects", {
# Normally, `drake` reacts to changes in dependencies.
x <- 4
make(plan = drake_plan(y = sqrt(x)))
x <- 5
make(plan = drake_plan(y = sqrt(x)))
make(plan = drake_plan(y = sqrt(4) + x))
# But not with ignore().
make(plan = drake_plan(y = sqrt(4) + ignore(x))) # Builds y.
x <- 6
make(plan = drake_plan(y = sqrt(4) + ignore(x))) # Skips y.
make(plan = drake_plan(y = sqrt(4) + ignore(x + 1))) # Skips y.
# What about imported functions?
f <- function(x) sqrt(4) + ignore(x + 1)
make(plan = drake_plan(x = f(2)))
readd(x)
f <- function(x) sqrt(4) + ignore(x + 2)
make(plan = drake_plan(x = f(2)))
readd(x)
f <- function(x) sqrt(5) + ignore(x + 2)
make(plan = drake_plan(x = f(2)))
readd(x)
})
}
}
\seealso{
\code{\link[=file_in]{file_in()}}, \code{\link[=file_out]{file_out()}}, \code{\link[=knitr_in]{knitr_in()}}
}
