% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind.r
\name{bind}
\alias{bind}
\alias{bind_rows}
\alias{bind_cols}
\title{Efficiently bind multiple data frames by row and column}
\usage{
bind_rows(..., .id = NULL)

bind_cols(...)
}
\arguments{
\item{...}{Data frames to combine.

Each argument can either be a data frame, a list that could be a data
frame, or a list of data frames.

When row-binding, columns are matched by name, and any missing
columns will be filled with NA.

When column-binding, rows are matched by position, so all data
frames must have the same number of rows. To match by value, not
position, see \link{mutate-joins}.}

\item{.id}{Data frame identifier.

When \code{.id} is supplied, a new column of identifiers is
created to link each row to its original data frame. The labels
are taken from the named arguments to \code{bind_rows()}. When a
list of data frames is supplied, the labels are taken from the
names of the list. If no names are found a numeric sequence is
used instead.}
}
\value{
\code{bind_rows()} and \code{bind_cols()} return the same type as
the first input, either a data frame, \code{tbl_df}, or \code{grouped_df}.
}
\description{
This is an efficient implementation of the common pattern of
\code{do.call(rbind, dfs)} or \code{do.call(cbind, dfs)} for binding many
data frames into one.
}
\details{
The output of \code{bind_rows()} will contain a column if that column
appears in any of the inputs.
}
\examples{
one <- starwars[1:4, ]
two <- starwars[9:12, ]

# You can supply data frames as arguments:
bind_rows(one, two)

# The contents of lists are spliced automatically:
bind_rows(list(one, two))
bind_rows(split(starwars, starwars$homeworld))
bind_rows(list(one, two), list(two, one))


# In addition to data frames, you can supply vectors. In the rows
# direction, the vectors represent rows and should have inner
# names:
bind_rows(
  c(a = 1, b = 2),
  c(a = 3, b = 4)
)

# You can mix vectors and data frames:
bind_rows(
  c(a = 1, b = 2),
  tibble(a = 3:4, b = 5:6),
  c(a = 7, b = 8)
)


# When you supply a column name with the `.id` argument, a new
# column is created to link each row to its original data frame
bind_rows(list(one, two), .id = "id")
bind_rows(list(a = one, b = two), .id = "id")
bind_rows("group 1" = one, "group 2" = two, .id = "groups")

# Columns don't need to match when row-binding
bind_rows(tibble(x = 1:3), tibble(y = 1:4))
\dontrun{
# Rows do need to match when column-binding
bind_cols(tibble(x = 1:3), tibble(y = 1:2))

# even with 0 columns
bind_cols(tibble(x = 1:3), tibble())
}

bind_cols(one, two)
bind_cols(list(one, two))
}
