% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip.r
\name{filter}
\alias{filter}
\alias{filter_}
\title{Return rows with matching conditions.}
\usage{
filter(.data, ...)

filter_(.data, ..., .dots)
}
\arguments{
\item{.data}{A tbl. All main verbs are S3 generics and provide methods
for \code{\link{tbl_df}}, \code{\link[dtplyr]{tbl_dt}} and \code{\link{tbl_sql}}.}

\item{...}{Logical predicates. Multiple conditions are combined with \code{&}.}

\item{.dots}{Used to work around non-standard evaluation. See
\code{vignette("nse")} for details.}
}
\value{
An object of the same class as \code{.data}.

  Data frame row names are silently dropped. To preserve, convert to an
  explicit variable.
}
\description{
Return rows with matching conditions.
}
\examples{
filter(mtcars, cyl == 8)
filter(mtcars, cyl < 6)

# Multiple criteria
filter(mtcars, cyl < 6 & vs == 1)
filter(mtcars, cyl < 6 | vs == 1)

# Multiple arguments are equivalent to and
filter(mtcars, cyl < 6, vs == 1)
}
\seealso{
Other single.table.verbs: \code{\link{arrange}},
  \code{\link{mutate}}, \code{\link{select}},
  \code{\link{slice}}, \code{\link{summarise}}
}

