% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeFunctions.R
\name{readLineages}
\alias{readLineages}
\title{Read in all trees from a lineages file}
\usage{
readLineages(
  file,
  states = NULL,
  palette = NULL,
  run_id = "",
  quiet = TRUE,
  append = NULL,
  format = "nexus",
  type = "jointpars"
)
}
\arguments{
\item{file}{IgPhyML lineage file}

\item{states}{states in parsimony model}

\item{palette}{deprecated}

\item{run_id}{id used for IgPhyML run}

\item{quiet}{avoid printing rubbish on screen?}

\item{append}{string appended to fasta files}

\item{format}{format of input file with trees}

\item{type}{Read in parsimony reconstructions or ancestral sequence
reconstructions? "jointpars" reads in parsimony states, 
others read in sequences in internal nodes}
}
\value{
A list of phylo objects from \code{file}.
}
\description{
Read in all trees from a lineages file
}
