% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_docker_image.R
\name{prepare_docker_image}
\alias{prepare_docker_image}
\title{Prepare Docker Image}
\usage{
prepare_docker_image(pkg = ".", dir_image = NULL,
  print_dockerfile = FALSE, dir_install = NULL, verbose = TRUE,
  r_version = NULL, dependencies = c("Depends", "Imports",
  "LinkingTo"), base = FALSE, recommended = FALSE, dir_src = NULL,
  prioritize_cran = TRUE, overwrite = TRUE, ...)
}
\arguments{
\item{pkg}{Path to a package, or within a package.}

\item{dir_image}{\code{character} directory where to create folder for 
all files for the Docker image, from where the Docker image can be build.}

\item{print_dockerfile}{\code{logical} should the resulting Dockerfile be
printed?}

\item{dir_install}{\code{character} where should the package be installed
on your system. Choose from `auto` (automatic detection), `temp` 
(temporary directory) or specify directory yourself.}

\item{verbose}{\code{logical} should messages be printed or not?}

\item{r_version}{\code{character} which version of base R to include in the 
Docker image, e.g. '3.6.0'. Defaults to NULL, which implies that the active 
version of R will apply.}

\item{dependencies}{character vector of dependency types to include.
    Choices are "Depends", "Imports", "LinkingTo", "Suggests",
    and "Enhances".  Defaults to \code{c("Depends", "Imports",
      "LinkingTo")}.
  }

\item{base}{Logical indicating whether to include dependencies on base
    packages that are included in the R installation. Defaults to
    FALSE.
    }

\item{recommended}{Logical indicating whether to include dependencies on
    recommended packages that are included in the R
    installation. Defaults to
    FALSE.
    }

\item{dir_src}{\code{character} directories with local source packages. 
Note, the source packages must have filenames like
(packageName)_(packageVersion).tar.gz, e.g. "recorder_0.8.2.tar.gz".
Put directories in prioritized order. The first directory will have the 
highest priority.}

\item{prioritize_cran}{\code{logical} should R dependency packages matched
with CRAN be prioritized over matches with local source packages?}

\item{overwrite}{\code{logical} if the directory for the files for the
Docker image already exists and is non-empty, should it be 
deleted/overwritten?}

\item{...}{optional arguments for `install.packages()`.}
}
\value{
\code{list} relevant meta data of the files, that constitute
the Docker image. As a side effect all necessary files for the Docker image -
including the resulting Dockerfile - are saved in the desired directory.
}
\description{
Prepares a Docker r-base image for your R package by (1) building and 
installing the package on your system, (2) identifying R package dependencies
of the package, (3) detecting the version numbers of the loaded and installed 
versions of these packages on your system, (4) linking the individual
packages to the right repositories (either CRAN or local repos) and (5) 
writing Dockerfile and creating all other files needed to build the 
Docker r-base image.
}
\examples{
\donttest{
# retrieve package directory for the 'dockr' package.
package_dir <- system.file(package = "dockr")
# this concludes the preparations. 

# now for the real action.

# create all files for a Docker image for the package in the current directory.
img <- prepare_docker_image(pkg = package_dir, dir_image = tempdir(), dir_install = "temp")

# look up meta data for files for Docker image.
img
}
}
