% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dockerfile.R
\docType{data}
\name{Dockerfile}
\alias{Dockerfile}
\title{A Dockerfile template}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
Dockerfile
}
\value{
A dockerfile template
}
\description{
This R6 object contains a series of methods designed to create a Dockerfile.
}
\section{Methods}{

\describe{
  \item{\code{RUN}}{add a RUN command to your Dockerfile}
  \item{\code{ADD}}{add an ADD command to your Dockerfile}
  \item{\code{COPY}}{add a COPY command to your Dockerfile}
  \item{\code{WORKDIR}}{add a WORKDIR command to your Dockerfile}
  \item{\code{EXPOSE}}{add an EXPOSE command to your Dockerfile}
  \item{\code{VOLUME}}{add a VOLUME command to your Dockerfile}
  \item{\code{CMD}}{add a CMD command to your Dockerfile}
  \item{\code{ENV}}{add an ENV command to your Dockerfile}
  \item{\code{ENTRYPOINT}}{add an ENTRYPOINT command to your Dockerfile}
  \item{\code{USER}}{add a USER command to your Dockerfile}
  \item{\code{ARG}}{add an ARG command to your Dockerfile}
  \item{\code{ONBUILD}}{add an ONBUILD command to your Dockerfile}
  \item{\code{STOPSIGNAL}}{add a STOPSIGNAL command to your Dockerfile}
  \item{\code{HEALTHCHECK}}{add an HEALTHCHECK command to your Dockerfile}
  \item{\code{SHELL}}{add a SHELL command to your Dockerfile}
  \item{\code{MAINTAINER}}{add a MAINTAINER command to your Dockerfile}
  \item{\code{print}}{print your Dockerfile}
  \item{\code{write}}{write your Dockerfile}
  \item{\code{switch_cmd}}{switch two commands in your Dockerfile}
  \item{\code{remove_cmd}}{remove a command in your Dockerfile}
}
}

\examples{
my_dock <- Dockerfile$new()
my_dock$RUN(r(install.packages("attempt", repo = "http://cran.irsn.fr/")))
my_dock$RUN("mkdir /usr/scripts")
my_dock$COPY("plumberfile.R", "/usr/scripts/plumber.R")
my_dock$EXPOSE(8000)
my_dock$CMD("Rscript /usr/scripts/torun.R ")
}
\keyword{datasets}
