% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dna.R
\name{[[.dnapath_list}
\alias{[[.dnapath_list}
\title{Extract results of a single pathway from a 'dnapath_list' object.}
\usage{
\method{[[}{dnapath_list}(x, i, ...)
}
\arguments{
\item{x}{A 'dnapath_list' object from \code{\link{dnapath}}.}

\item{i}{The index specifying which pathway to extract.}

\item{...}{Additional arguments are ignored.}
}
\value{
A 'dnapath' object containing a single pathway result.
}
\description{
Extract results of a single pathway from a 'dnapath_list' object.
}
\examples{
data(meso)
data(p53_pathways)
set.seed(0)
results <- dnapath(x = meso$gene_expression, pathway_list = p53_pathways,
                   groups = meso$groups, n_perm = 10)
results[[1]]
}
