% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wbc.R
\name{choose_test.wbc}
\alias{choose_test.wbc}
\title{Filter final result}
\usage{
\method{choose_test}{wbc}(obj, test = "mis", group_id = T)
}
\arguments{
\item{obj}{An object. Class wbc.}

\item{test}{A character scalar. Parameters, which use to filter the final dataset, default: "mis":
"ok" - wbc, which is calculated correct,
"mis" - wbc, which is calculated incorrect.}

\item{group_id}{A logical scalar, default is TRUE.True is grouped by id, otherwise, it isn't grouped.}
}
\value{
The dataset by a value of \code{test}.
}
\description{
Filter final result
}
\examples{
id <- c("01", "02", "03")
wbc_post <- c(5.6, 7.8, 8.1)
lym_rel_post <- c(21, 25, 30)
lym_abs_post <- c(1.18, 1.95, 2.13)

df <- data.frame(
  id, wbc_post, lym_rel_post, lym_abs_post,
  stringsAsFactors = FALSE
)

wbcc <- system.file("wbcc.xlsx", package = "dmtools")
obj_wbc <- wbc(wbcc, id)

obj_wbc <- check(obj_wbc, df)
choose_test(obj_wbc, "mis")

}
