% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dm_nest_tbl.R
\name{dm_nest_tbl}
\alias{dm_nest_tbl}
\title{Nest a table inside its dm}
\usage{
dm_nest_tbl(dm, child_table, into = NULL)
}
\arguments{
\item{dm}{A dm.}

\item{child_table}{A terminal table with one parent table.}

\item{into}{The table to nest \code{child_tables} into, optional as it can be guessed
from the foreign keys unambiguously but useful to be explicit.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{dm_nest_tbl()} converts a child table to a nested column in its parent
table.
The child table should not have children itself (i.e. it needs to be a
\emph{terminal child table}).
}
\examples{
nested_dm <-
  dm_nycflights13() \%>\%
  dm_select_tbl(airlines, flights) \%>\%
  dm_nest_tbl(flights)

nested_dm

nested_dm$airlines
}
\seealso{
\code{\link[=dm_wrap_tbl]{dm_wrap_tbl()}}, \code{\link[=dm_unwrap_tbl]{dm_unwrap_tbl()}}, \code{\link[=dm_pack_tbl]{dm_pack_tbl()}}
}
