% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyr.R
\name{tidyr_table_manipulation}
\alias{tidyr_table_manipulation}
\alias{unite.zoomed_dm}
\alias{separate.zoomed_dm}
\title{\pkg{tidyr} table manipulation methods for zoomed dm objects}
\usage{
\method{unite}{zoomed_dm}(data, col, ..., sep = "_", remove = TRUE, na.rm = FALSE)

\method{separate}{zoomed_dm}(data, col, into, sep = "[^[:alnum:]]+", remove = TRUE, ...)
}
\arguments{
\item{data}{object of class \code{zoomed_dm}}

\item{col}{For \code{unite.zoomed_dm}: see \code{\link[tidyr:unite]{tidyr::unite}}

For \code{separate.zoomed_dm}: see \code{\link[tidyr:separate]{tidyr::separate}}}

\item{...}{For \code{unite.zoomed_dm}: see \code{\link[tidyr:unite]{tidyr::unite}}

For \code{separate.zoomed_dm}: see \code{\link[tidyr:separate]{tidyr::separate}}}

\item{sep}{For \code{unite.zoomed_dm}: see \code{\link[tidyr:unite]{tidyr::unite}}

For \code{separate.zoomed_dm}: see \code{\link[tidyr:separate]{tidyr::separate}}}

\item{remove}{For \code{unite.zoomed_dm}: see \code{\link[tidyr:unite]{tidyr::unite}}

For \code{separate.zoomed_dm}: see \code{\link[tidyr:separate]{tidyr::separate}}}

\item{na.rm}{see \code{\link[tidyr:unite]{tidyr::unite}}}

\item{into}{see \code{\link[tidyr:separate]{tidyr::separate}}}
}
\description{
Use these methods without the '.zoomed_dm' suffix (see examples).
}
\examples{
\dontshow{if (rlang::is_installed("nycflights13")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
zoom_united <- dm_nycflights13() \%>\%
  dm_zoom_to(flights) \%>\%
  select(year, month, day) \%>\%
  unite("month_day", month, day)
zoom_united
zoom_united \%>\%
  separate(month_day, c("month", "day"))
\dontshow{\}) # examplesIf}
}
