# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' fast set intersection tool assumes sorted vectors A and B
#'
#' @param A sorted integer vector A
#' @param B sorted integer vector B
#' @returns vector of resulting intersection
#' @export
cppIntersection <- function(A, B) {
    .Call(`_dlmtree_cppIntersection`, A, B)
}

#' dlmtree model with fixed Gaussian process approach
#'
#' @param model A list of parameter and data contained for the model fitting
#' @returns A list of dlmtree model fit, mainly posterior mcmc samples
#' @export
dlmtreeGPFixedGaussian <- function(model) {
    .Call(`_dlmtree_dlmtreeGPFixedGaussian`, model)
}

#' dlmtree model with Gaussian process approach
#'
#' @param model A list of parameter and data contained for the model fitting
#' @returns A list of dlmtree model fit, mainly posterior mcmc samples
#' @export
dlmtreeGPGaussian <- function(model) {
    .Call(`_dlmtree_dlmtreeGPGaussian`, model)
}

#' dlmtree model with shared HDLM approach
#'
#' @param model A list of parameter and data contained for the model fitting
#' @returns A list of dlmtree model fit, mainly posterior mcmc samples
#' @export
dlmtreeHDLMGaussian <- function(model) {
    .Call(`_dlmtree_dlmtreeHDLMGaussian`, model)
}

#' dlmtree model with HDLMM approach
#'
#' @param model A list of parameter and data contained for the model fitting
#' @returns A list of dlmtree model fit, mainly posterior mcmc samples
#' @export
dlmtreeHDLMMGaussian <- function(model) {
    .Call(`_dlmtree_dlmtreeHDLMMGaussian`, model)
}

#' dlmtree model with fixed Gaussian approach
#'
#' @param model A list of parameter and data contained for the model fitting
#' @returns A list of dlmtree model fit, mainly posterior mcmc samples
#' @export
dlmtreeTDLMFixedGaussian <- function(model) {
    .Call(`_dlmtree_dlmtreeTDLMFixedGaussian`, model)
}

#' dlmtree model with nested Gaussian approach
#'
#' @param model A list of parameter and data contained for the model fitting
#' @returns A list of dlmtree model fit, mainly posterior mcmc samples
#' @export
dlmtreeTDLMNestedGaussian <- function(model) {
    .Call(`_dlmtree_dlmtreeTDLMNestedGaussian`, model)
}

#' dlmtree model with nested HDLM approach
#'
#' @param model A list of parameter and data contained for the model fitting
#' @returns A list of dlmtree model fit, mainly posterior mcmc samples
#' @export
dlmtreeTDLM_cpp <- function(model) {
    .Call(`_dlmtree_dlmtreeTDLM_cpp`, model)
}

#' Calculates the distributed lag effect with DLM matrix for non-linear models.
#'
#' @param dlnm A numeric matrix containing the model fit information
#' @param predAt Number of splits in the model
#' @param nlags total number of lags
#' @param nsamp number of mcmc iterations
#' @param center center parameter
#' @param se Standard error parameter
#' @returns A cube object of lag effect x lag x mcmc
#' @export
dlnmEst <- function(dlnm, predAt, nlags, nsamp, center, se) {
    .Call(`_dlmtree_dlnmEst`, dlnm, predAt, nlags, nsamp, center, se)
}

#' Calculates the posterior inclusion probability (PIP).
#'
#' @param dlnm A numeric matrix containing the model fit information
#' @param nlags total number of lags
#' @param niter number of mcmc iterations
#'
#' @returns A matrix of split counts per mcmc
#' @export
splitPIP <- function(dlnm, nlags, niter) {
    .Call(`_dlmtree_splitPIP`, dlnm, nlags, niter)
}

#' Calculates the distributed lag effect with DLM matrix for non-linear models.
#'
#' @param dlnm A numeric matrix containing the model fit information
#' @param predAt Number of splits in the model
#' @param nlags total number of lags
#' @param nsamp number of mcmc iterations
#' @param center center parameter
#'
#' @returns A cube object of lag effect x lag x mcmc
#' @export
dlnmPLEst <- function(dlnm, predAt, nlags, nsamp, center) {
    .Call(`_dlmtree_dlnmPLEst`, dlnm, predAt, nlags, nsamp, center)
}

#' Calculates the distributed lag effect with DLM matrix for linear models.
#'
#' @param dlm A numeric matrix containing the model fit information
#' @param nlags total number of lags
#' @param nsamp number of mcmc iterations
#' @returns A cube object of lag effect x lag x mcmc
#' @export
dlmEst <- function(dlm, nlags, nsamp) {
    .Call(`_dlmtree_dlmEst`, dlm, nlags, nsamp)
}

#' Calculates the lagged interaction effects with MIX matrix for linear models.
#'
#' @param dlm A numeric matrix containing the model fit information
#' @param nlags total number of lags
#' @param nsamp number of mcmc iterations
#' @returns A cube object of interaction effect x lag x mcmc
#' @export
mixEst <- function(dlm, nlags, nsamp) {
    .Call(`_dlmtree_mixEst`, dlm, nlags, nsamp)
}

#' dlmtree model with monotone tdlnm approach
#'
#' @param model A list of parameter and data contained for the model fitting
#' @returns A list of dlmtree model fit, mainly posterior mcmc samples
#' @export
monotdlnm_Cpp <- function(model) {
    .Call(`_dlmtree_monotdlnm_Cpp`, model)
}

#' Integrates (0,inf) over multivariate normal 
#'
#' @param mu vector of mean parameters
#' @param sigma covariance matrix
#' @returns double 
#' @export
zeroToInfNormCDF <- function(mu, sigma) {
    .Call(`_dlmtree_zeroToInfNormCDF`, mu, sigma)
}

#' Truncated multivariate normal sampler, mean mu, cov sigma, truncated (0, Inf)
#'
#' @param mu vector of mean parameters
#' @param sigma covariance matrix
#' @param iter number of iterations
#' @returns VectorXd
#' @export
rtmvnorm <- function(mu, sigma, iter) {
    .Call(`_dlmtree_rtmvnorm`, mu, sigma, iter)
}

#' Multiple draw polya gamma latent variable for var c[i] with size b[i]
#'
#' @param b vector of binomial sizes
#' @param z vector of parameters
#' @returns Eigen::VectorXd 
#' @export
rcpp_pgdraw <- function(b, z) {
    .Call(`_dlmtree_rcpp_pgdraw`, b, z)
}

#' dlmtree model with tdlmm approach
#'
#' @param model A list of parameter and data contained for the model fitting
#' @returns A list of dlmtree model fit, mainly posterior mcmc samples
#' @export
tdlmm_Cpp <- function(model) {
    .Call(`_dlmtree_tdlmm_Cpp`, model)
}

#' dlmtree model with tdlnm approach
#'
#' @param model A list of parameter and data contained for the model fitting
#' @return A list of dlmtree model fit, mainly posterior mcmc samples
#' @export
tdlnm_Cpp <- function(model) {
    .Call(`_dlmtree_tdlnm_Cpp`, model)
}

