% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/diversity.R
\name{values}
\alias{values}
\title{Pre-process the raw data}
\usage{
values(data, category_row = FALSE, norm = NULL, filter = NULL,
  binary = FALSE)
}
\arguments{
\item{data}{A numeric matrix with entities \eqn{i} in the rows and categories \eqn{j} in the columns. Cells show the respective value (value of abundance) of entity \eqn{i} in the category \eqn{j}. It can also be a transpose of the previous matrix, that is, a matrix with categories in the rows and entities in the columns. Yet in that case, the argument "category_row" has to be set to TRUE. The matrix must include names for the rows and the columns. The argument "data", also accepts a dataframe with three columns in the following order: entity, category and value.}

\item{category_row}{A flag to indicate that categories are in the rows. The analysis assumes that the categories are in the columns of the matrix. If the categories are in the rows and the entities in the columns, then the argument "category_row" has to be set to TRUE. The default value is FALSE.}

\item{norm}{Methods to compute normalized values. Possible values are 'p', 'proportions', 'rca', 'rca_norm' and 'ai'. RCA refers to Revealed Comparative Advantages [Balassa 1986], rca_norm normalizes the RCAs between -1 and with 1, ai refers to the Activity Index.}

\item{filter}{A threshold below which values are replaced with NA.}

\item{binary}{A boolean value to indicate if values distinct from NA are replaced with 1.}
}
\value{
A matrix with the raw, normalized, filtered and\/or binarized data.
}
\description{
Allows to filter, binarize and/or normalize raw data.
Also filter and binarization is available.
}
\details{
If the three arguments 'norm', 'filter' and 'binary' are used, then the same sequential order is applied in the calculations.
}
\examples{
#raw values
values(data=pantheon)
values(data = scidat)
#proportions
values(data = scidat, norm='p')
#revealed comparative advantages
values(data = scidat, norm='rca')
values(data = scidat, norm='rca', filter=1)
values(data = scidat, norm='rca', filter=1, binary=TRUE)
}
\references{
Balassa, B. (1986). Comparative advantage in manufactured goods: a reappraisal. The Review of Economics and Statistics, 315-319.
}

