% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metacommunity.R
\name{metacommunity}
\alias{metacommunity}
\alias{metacommunity.matrix}
\alias{metacommunity.abundances}
\title{Aggregate communities into a metacommunity}
\usage{
metacommunity(x, name = "metacommunity", ...)

\method{metacommunity}{matrix}(
  x,
  name = "metacommunity",
  weights = rep(1, nrow(x)),
  as_numeric = TRUE,
  ...,
  check_arguments = TRUE
)

\method{metacommunity}{abundances}(
  x,
  name = "metacommunity",
  as_numeric = FALSE,
  ...,
  check_arguments = TRUE
)
}
\arguments{
\item{x}{An object of class \link{abundances} that contains several communities or
a matrix of abundances with communities in rows and species in columns.}

\item{name}{The name of the metacommunity}

\item{...}{Unused.}

\item{weights}{The weights of the sites of the species distributions.}

\item{as_numeric}{If \code{TRUE}, a number or a numeric vector is returned rather than a tibble.}

\item{check_arguments}{If \code{TRUE}, the function arguments are verified.
Should be set to \code{FALSE} to save time when the arguments have been checked elsewhere.}
}
\value{
An object of class \link{abundances} with a single row or a named vector
if \code{as_numeric = TRUE}.
}
\description{
Abundances of communities are summed according to their weights to obtain
the abundances of the metacommunity.
}
\details{
The total abundance of the metacommunity is by design equal to the sum
of community abundances so that the information used by diversity estimators.
A consequence is that equal weights lead to a metacommunity whose species
abundances are the sum of community species abundances.

If community weights are not equal then the metacommunity abundances are
in general not integer.
Most diversity estimators can't be applied to non-integer abundances but the knowledge
of the sample coverage of each community allow "ChaoShen" and "Grassberger"
estimators.
}
\examples{
metacommunity(paracou_6_abd)

metacommunity(paracou_6_abd)

}
