% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZIPoisson.R
\name{ZIPoisson}
\alias{ZIPoisson}
\title{Create a zero-inflated Poisson distribution}
\usage{
ZIPoisson(lambda, pi)
}
\arguments{
\item{lambda}{Parameter of the Poisson component of the distribution.
Can be any positive number.}

\item{pi}{Zero-inflation probability, can be any value in \verb{[0, 1]}.}
}
\value{
A \code{ZIPoisson} object.
}
\description{
Zero-inflated Poisson distributions are frequently used to model counts
with many zero observations.
}
\details{
We recommend reading this documentation on
\url{https://alexpghayes.github.io/distributions3/}, where the math
will render with additional detail.

In the following, let \eqn{X} be a zero-inflated Poisson random variable with parameter
\code{lambda} = \eqn{\lambda}.

\strong{Support}: \eqn{\{0, 1, 2, 3, ...\}}{{0, 1, 2, 3, ...}}

\strong{Mean}: \eqn{(1 - \pi) \cdot \lambda}

\strong{Variance}: \eqn{(1 - \pi) \cdot \lambda \cdot (1 + \pi \cdot \lambda)}

\strong{Probability mass function (p.m.f.)}:

\deqn{
    P(X = k) = \pi \cdot I_{0}(k) + (1 - \pi) \cdot f(k; \lambda)
  }{
    P(X = k) = \pi \cdot I_{0}(k) + (1 - \pi) \cdot f(k; \lambda)
  }

where \eqn{I_{0}(k)} is the indicator function for zero and
\eqn{f(k; \lambda)} is the p.m.f. of the \code{\link{Poisson}}
distribution.

\strong{Cumulative distribution function (c.d.f.)}:

\deqn{
    P(X \le k) = \pi + (1 - \pi) \cdot F(k; \lambda)
  }{
    P(X \le k) = \pi + (1 - \pi) \cdot F(k; \lambda)
  }

where \eqn{F(k; \lambda)} is the c.d.f. of the \code{\link{Poisson}} distribution.

\strong{Moment generating function (m.g.f.)}:

\deqn{
    E(e^{tX}) = \pi + (1 - \pi) \cdot e^{\lambda (e^t - 1)}
  }{
    E(e^(tX)) = \pi + (1 - \pi) \cdot e^(\lambda (e^t - 1))
  }
}
\examples{
## set up a zero-inflated Poisson distribution
X <- ZIPoisson(lambda = 2.5, pi = 0.25)
X

## standard functions
pdf(X, 0:8)
cdf(X, 0:8)
quantile(X, seq(0, 1, by = 0.25))

## cdf() and quantile() are inverses for each other
quantile(X, cdf(X, 3))

## density visualization
plot(0:8, pdf(X, 0:8), type = "h", lwd = 2)

## corresponding sample with histogram of empirical frequencies
set.seed(0)
x <- random(X, 500)
hist(x, breaks = -1:max(x) + 0.5)
}
\seealso{
Other discrete distributions: 
\code{\link{Bernoulli}()},
\code{\link{Binomial}()},
\code{\link{Categorical}()},
\code{\link{Geometric}()},
\code{\link{HurdleNegativeBinomial}()},
\code{\link{HurdlePoisson}()},
\code{\link{HyperGeometric}()},
\code{\link{Multinomial}()},
\code{\link{NegativeBinomial}()},
\code{\link{Poisson}()},
\code{\link{ZINegativeBinomial}()},
\code{\link{ZTNegativeBinomial}()},
\code{\link{ZTPoisson}()}
}
\concept{discrete distributions}
