% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DistributionDecorator_CoreStatistics.R
\name{genExp}
\alias{genExp}
\title{Generalised Expectation of a Distribution}
\usage{
genExp(object, trafo = NULL)
}
\arguments{
\item{object}{Distribution.}

\item{trafo}{transformation for expectation calculation, see details.}
}
\value{
The given expectation as a numeric, otherwise NULL.
}
\description{
A generalised expectation function for distributions, for arithmetic mean and more complex
numeric calculations.
}
\details{
The expectation of a probability distribution can be numerically calculated in a variety
of different ways, some more efficient than others depending on what is available, this function first
checks which analytic methods are present before selecting a numeric strategy.

If trafo = NULL, then the arithmetic mean is calculated, i.e. the approximation to \eqn{E[X]}. Any
transformation must be given as a function, for example \code{trafo = function(x) x^2}
(which is the second moment).

Can only be used after decorating with \code{\link{CoreStatistics}}.
}
\section{R6 Usage}{
 $genExp(trafo = NULL)
}

\seealso{
\code{\link{mean}}, \code{\link{CoreStatistics}} and \code{\link{decorate}}.
}
