% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloads.R
\name{get_seq_for_DB}
\alias{get_seq_for_DB}
\alias{get_seq_for_DB_fix}
\title{Get nucleotide sequences from NCBI}
\usage{
get_seq_for_DB(
  ids,
  db,
  check.result = FALSE,
  return = "data.frame",
  fasta.file = NULL,
  exclude.from.download = FALSE,
  exclude.var,
  exclude.pattern,
  exclude.fixed = TRUE,
  verbose = TRUE
)

get_seq_for_DB_fix(res.data, db, verbose = TRUE)
}
\arguments{
\item{ids}{vector of NCBI sequences' identification numbers: GenBank accession numbers, GenInfo identifiers (GI) or Entrez unique identifiers (UID)}

\item{db}{character; NCBI database for search. See \link[rentrez]{entrez_dbs}() for possible values}

\item{check.result}{logical; check if download was done correctly}

\item{return}{character; sequence returned object; possible values are "vector", "data.frame" and "fasta"}

\item{fasta.file}{character; FASTA file name and path, only used if \code{return = "fasta"}}

\item{exclude.from.download}{logical; ignore some sequences while downloading}

\item{exclude.var}{vector that is used to define which sequences should be ignored, only used if \code{exclude.from.download = TRUE}.}

\item{exclude.pattern}{value that matches to \code{exclude.var} and marks unwanted sequences, only used if \code{exclude.from.download = TRUE}}

\item{exclude.fixed}{logical; match \code{exclude.pattern} as is, only used if \code{exclude.from.download = TRUE}.}

\item{verbose}{logical; show messages}

\item{res.data}{data.frame; data frame of nucleotide ids and previously downloaded sequences}
}
\value{
If \code{return = "vector"} function returns vector of nucleotide sequences,
\code{return = "data.frame"} - data frame with nucleotide ids and nucleotide sequences,
\code{return = "fasta"} - writes FASTA file, no data returned.
}
\description{
Retrieves nucleotide sequences from NCBI for given identification numbers.
}
\details{
Master records (for example, in WGS-project) do not contain any nucleotide.
They might be excluded from download with \code{exclude.from.download} parameters.
However this has no affect and such ids do not have to be excluded when loading.

If writing FASTA to existing FASTA file, sequences are appended.
}
\section{Functions}{
\itemize{
\item \code{get_seq_for_DB}: Retrieves NCBI nucleotide sequences for given identification numbers.

\item \code{get_seq_for_DB_fix}: Checks the downloads and tries to retrieve the compromised data.
}}

\examples{
ids<-c(2134240466, 2134240465, 2134240464)
fasta.file<-tempfile()
get_seq_for_DB (ids = ids, db = "nucleotide", check.result = TRUE,
                return = "fasta", fasta.file = fasta.file, exclude.from.download=FALSE)
file.remove(fasta.file)

}
\author{
Elena N. Filatova
}
