% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/closest_market_price.R
\name{closest_market_price}
\alias{closest_market_price}
\title{Closest market price}
\usage{
closest_market_price(
  asset,
  datetime,
  market_prices,
  price_only = FALSE,
  exact = FALSE,
  substitute_datetime = FALSE
)
}
\arguments{
\item{asset}{Character vector of assets' names to look for.}

\item{datetime}{POSIXct of the datetime at which looking for the asset's
price.}

\item{market_prices}{Data frame containing the market prices.}

\item{price_only}{Logical. If TRUE then only the price is returned.}

\item{exact}{Logical. If TRUE then it looks for market prices at the same
datetime only, otherwise it looks for the nearest before the datetime.}

\item{substitute_datetime}{Logical. If TRUE the datetime is substituted
with the datetime argument.}
}
\value{
The data frame of closest market prices.
}
\description{
Find the market price closest to a certain datetime and for
specific assets.
}
\seealso{
\code{\link{evaluate}},
\code{lubridate::\link[lubridate:round_date]{round_date}}
}
