% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rechunk.r
\name{rechunk}
\alias{rechunk}
\title{Increase or decrease the number of chunks in the disk.frame}
\usage{
rechunk(
  df,
  nchunks,
  outdir = attr(df, "path"),
  shardby = NULL,
  overwrite = TRUE,
  shardby_function = "hash",
  sort_splits = NULL,
  desc_vars = NULL
)
}
\arguments{
\item{df}{the disk.frame to rechunk}

\item{nchunks}{number of chunks}

\item{outdir}{the output directory}

\item{shardby}{the shardkeys}

\item{overwrite}{overwrite the output directory}

\item{shardby_function}{splitting of chunks: "hash" for hash function or "sort" for semi-sorted chunks}

\item{sort_splits}{for the "sort" shardby function, a dataframe with the split values.}

\item{desc_vars}{for the "sort" shardby function, the variables to sort descending.}
}
\description{
Increase or decrease the number of chunks in the disk.frame
}
\examples{
# create a disk.frame with 2 chunks in tempdir()
cars.df = as.disk.frame(cars, nchunks = 2)

# re-chunking cars.df to 3 chunks, done "in-place" to the same folder as cars.df
rechunk(cars.df, 3)

new_path = tempfile(fileext = ".df")
# re-chunking cars.df to 4 chunks, shard by speed, and done "out-of-place" to a new directory
cars2.df = rechunk(cars.df, 4, outdir=new_path, shardby = "speed")

# clean up cars.df
delete(cars.df)
delete(cars2.df)
}
