% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disk.frame.r
\name{add_meta}
\alias{add_meta}
\title{Add metadata to the disk.frame}
\usage{
add_meta(df, ..., nchunks = nchunks.disk.frame(df), shardkey = "",
  shardchunks = -1)
}
\arguments{
\item{df}{a disk.frame}

\item{...}{any other metadata the user wishes to keep.}

\item{nchunks}{number of chunks}

\item{shardkey}{the shard key}

\item{shardchunks}{The number of chunks to shard to. Sometimes the number of actual file chunks is different to the number of intended chunks. In this case the shardchunks is the intended number}
}
\description{
Add metadata to the disk.frame
}
\examples{
cars.df = as.disk.frame(cars)

# adding some useless metadata to the repo
add_meta(cars.df, useless = TRUE)

# clean up
delete(cars.df)
}
