% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_base.R
\name{get_demanded_quantities}
\alias{get_demanded_quantities}
\alias{get_demanded_quantities,model_base-method}
\title{Demanded quantities.}
\usage{
get_demanded_quantities(object, parameters)

\S4method{get_demanded_quantities}{model_base}(object, parameters)
}
\arguments{
\item{object}{A model object.}

\item{parameters}{A vector of model's parameters.}
}
\value{
A vector with the demanded quantities evaluated at the given parameter vector.
}
\description{
Calculates the demanded quantity for each observation.
}
\examples{
\donttest{
simulated_data <- simulate_model_data(
  "diseq_basic", 500, 3, # model type, observed entities, observed time points
  -0.9, 8.9, c(0.3, -0.2), c(-0.03, -0.01), # demand coefficients
  0.9, 4.2, c(0.03), c(-0.05, 0.02) # supply coefficients
)

# initialize the model
model <- new(
  "diseq_basic", # model type
  c("id", "date"), "Q", "P", # keys, quantity, and price variables
  "P + Xd1 + Xd2 + X1 + X2", "P + Xs1 + X1 + X2", # equation specifications
  simulated_data, # data
  use_correlated_shocks = TRUE # allow shocks to be correlated
)

# estimate the model object
est <- estimate(model)

# get estimated demanded quantities
demq <- get_demanded_quantities(model, est@coef)
}
}
\seealso{
get_aggregate_demand
}
