% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.disag_model}
\alias{predict.disag_model}
\title{Predict mean and uncertainty from the disaggregation model result}
\usage{
\method{predict}{disag_model}(object, newdata = NULL, predict_iid = FALSE, N = 100, CI = 0.95, ...)
}
\arguments{
\item{object}{disag_model object returned by disag_model function.}

\item{newdata}{If NULL, predictions are made using the data in model_output. 
If this is a raster stack or brick, predictions will be made over this data.}

\item{predict_iid}{logical. If TRUE, any polygon iid effect from the model will be used in the prediction. Default FALSE.}

\item{N}{Number of realisations. Default: 100.}

\item{CI}{Confidence interval to be calculated from the realisations. Default: 0.95.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
An object of class \emph{disag_prediction} which consists of a list of two objects: 
 \item{mean_prediction }{List of:
  \itemize{
   \item \emph{prediction} Raster of mean predictions based.
   \item \emph{field} Raster of the field component of the linear predictor.
   \item \emph{iid} Raster of the iid component of the linear predictor.
   \item \emph{covariates} Raster of the covariate component of the linear predictor.
  }} 
 \item{uncertainty_prediction: }{List of:
  \itemize{
   \item \emph{realisations} RasterStack of realisations of predictions. Number of realisations defined by argument \emph{N}.
   \item \emph{predictions_ci} RasterStack of the upper and lower credible intervals. Defined by argument \emph{CI}.
  }}
}
\description{
\emph{predict.disag_model} function takes a \emph{disag_model} object created by \emph{disaggregation::disag_model} and 
predicts mean and uncertainty maps.
}
\details{
To predict over a different spatial extent to that used in the model, 
a RasterStack covering the region to make predictions over is passed to the argument \emph{newdata}. 
If this is not given predictions are made over the data used in the fit.

The \emph{predict_iid} logical flag should be set to TRUE if the results of the iid effect from the model are to be used in the prediction. 

For the uncertainty calculations, the number of the realisations and the size of the confidence interval to be calculated 
are given by the arguments \emph{N} and \emph{CI} respectively.
}
\examples{
\dontrun{
predict(fit_result)
}

}
