% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.twoStepsBenchmark}
\alias{plot.twoStepsBenchmark}
\alias{plot.threeRuleSmooth}
\alias{plot.tscomparison}
\alias{autoplot.twoStepsBenchmark}
\alias{autoplot.threeRuleSmooth}
\alias{autoplot.tscomparison}
\title{Plotting disaggR objects}
\usage{
\method{plot}{twoStepsBenchmark}(
  x,
  xlab = NULL,
  ylab = NULL,
  start = NULL,
  end = NULL,
  col = default_col_pal(x),
  lty = default_lty_pal(x),
  show.legend = TRUE,
  main = NULL,
  mar = default_margins(main, xlab, ylab),
  ...
)

\method{plot}{threeRuleSmooth}(
  x,
  xlab = NULL,
  ylab = NULL,
  start = NULL,
  end = NULL,
  col = default_col_pal(x),
  lty = default_lty_pal(x),
  show.legend = TRUE,
  main = NULL,
  mar = default_margins(main, xlab, ylab),
  ...
)

\method{plot}{tscomparison}(
  x,
  xlab = NULL,
  ylab = NULL,
  start = NULL,
  end = NULL,
  col = default_col_pal(x),
  lty = default_lty_pal(x),
  show.legend = TRUE,
  main = NULL,
  mar = default_margins(main, xlab, ylab),
  ...
)

autoplot.twoStepsBenchmark(
  object,
  xlab = NULL,
  ylab = NULL,
  start = NULL,
  end = NULL,
  col = default_col_pal(object),
  lty = default_lty_pal(object),
  show.legend = TRUE,
  main = NULL,
  mar = NULL,
  theme = default_theme_ggplot(object, start, end, show.legend, xlab, ylab, mar),
  ...
)

autoplot.threeRuleSmooth(
  object,
  xlab = NULL,
  ylab = NULL,
  start = NULL,
  end = NULL,
  col = default_col_pal(object),
  lty = default_lty_pal(object),
  show.legend = TRUE,
  main = NULL,
  mar = NULL,
  theme = default_theme_ggplot(object, start, end, show.legend, xlab, ylab, mar),
  ...
)

autoplot.tscomparison(
  object,
  xlab = NULL,
  ylab = NULL,
  start = NULL,
  end = NULL,
  col = default_col_pal(object),
  lty = default_lty_pal(object),
  show.legend = TRUE,
  main = NULL,
  mar = NULL,
  theme = default_theme_ggplot(object, start, end, show.legend, xlab, ylab, mar),
  ...
)
}
\arguments{
\item{x}{(for the plot method) a tscomparison, a twoStepsBenchmark or a
threeRuleSmooth.}

\item{xlab}{the title for the x axis}

\item{ylab}{the title for the y axis}

\item{start}{a numeric of length 1 or 2. The start of the plot.}

\item{end}{a numeric of length 1 or 2. The end of the plot.}

\item{col}{the color scale applied on the plot. Could be a vector of colors,
or a function from n to a color vector of size n.}

\item{lty}{the linetype scales applied on the plot. Could be a vector of
linetypes, or a function from n to a linetypes vector of size n.}

\item{show.legend}{\code{TRUE} or \code{FALSE}. Should an automatic legend be added to
the plot.}

\item{main}{a character of length 1, the title of the plot}

\item{mar}{a numeric of length 4, the margins of the plot specified in the
form \code{c(bottom, left, top, right)}.}

\item{...}{other arguments passed either to ggplot or plot}

\item{object}{(for the autoplot method) a tscomparison, a twoStepsBenchmark
or a threeRuleSmooth.}

\item{theme}{a ggplot theme object to replace the default one (only for
autoplot methods)}
}
\value{
\code{NULL} for the plot methods, the ggplot object for the autoplot
methods
}
\description{
Plot methods for objects of class \code{"tscomparison"}, \link{threeRuleSmooth}
and \link{twoStepsBenchmark}. :
\itemize{
\item \code{plot} draws a plot with base graphics
\item \code{autoplot} produces a ggplot object
}

Objects of class \code{tscomparison} can be produced with the functions
\link{in_sample}, \link{in_scatter}, \link{in_revisions}, \link{in_disaggr}.
}
\examples{
benchmark <- twoStepsBenchmark(turnover,construction,include.rho = TRUE)
plot(benchmark)
plot(in_sample(benchmark))
if(require("ggplot2")) {
  autoplot(in_disaggr(benchmark,type="changes"),
           start=c(2015,1),
           end=c(2020,12))
}
plot(in_scatter(benchmark),xlab="title x",ylab="title y")
}
