% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perturbPlot2d.R
\name{perturbPlot2d}
\alias{perturbPlot2d}
\title{Perturbation Plot}
\usage{
perturbPlot2d(Tc, annotation, minSize=5, ...)
}
\arguments{
\item{Tc}{a numeric matrix. The columns are genes or phosphorylation sites and the columns are treatments 
vs control statistics.}

\item{annotation}{a list with names correspond to pathways or kinases and elements correspond to genes or
substrates belong to each pathway or kinase, respectively.}

\item{minSize}{the size of annotation groups to be considered for calculating enrichment. Groups 
that are smaller than the minSize will be removed from the analysis.}

\item{...}{parameters for controling the plot.}
}
\value{
a list of coordinates for pathways or kinases
}
\description{
This function takes in a matrix of test statistics with two columns (2-dimensional space) and the 
annotation list such as pathway annotation or kinase-substrate annotation, and visualize the enrichment
of pathways or kinases in direction specific manner.
}
\examples{
# load the phosphoproteomics dataset
data(HEK)

# load the kinase-substrate annoations
data(PhosphoSite)

perturbPlot2d(Tc=HEK, annotation=PhosphoSite.mouse, cex=3)

}
