% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_class_weights.R
\name{class_weights}
\alias{class_weights}
\title{Parameters for class weights for imbalanced problems}
\usage{
class_weights(range = c(1, 10), trans = NULL)
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::log10_trans()} or \code{scales::reciprocal_trans()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}
}
\description{
This parameter can be used to moderate how much influence certain classes
receive during training.
}
\details{
Used in \code{lantern::lanter_logistic_reg()} and \code{lantern::lanter_mlp()}
}
\examples{
class_weights()
}
