/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers.prefixmapper;

import com.google.i18n.phonenumbers.prefixmapper.PhonePrefixMapStorageStrategy;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.SortedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultMapStorage
extends PhonePrefixMapStorageStrategy {
    private int[] phoneNumberPrefixes;
    private String[] descriptions;

    @Override
    public int getPrefix(int index) {
        return this.phoneNumberPrefixes[index];
    }

    @Override
    public String getDescription(int index) {
        return this.descriptions[index];
    }

    @Override
    public void readFromSortedMap(SortedMap<Integer, String> sortedPhonePrefixMap) {
        this.numOfEntries = sortedPhonePrefixMap.size();
        this.phoneNumberPrefixes = new int[this.numOfEntries];
        this.descriptions = new String[this.numOfEntries];
        int index = 0;
        for (int prefix : sortedPhonePrefixMap.keySet()) {
            this.phoneNumberPrefixes[index++] = prefix;
            this.possibleLengths.add((int)Math.log10(prefix) + 1);
        }
        sortedPhonePrefixMap.values().toArray(this.descriptions);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        this.numOfEntries = objectInput.readInt();
        if (this.phoneNumberPrefixes == null || this.phoneNumberPrefixes.length < this.numOfEntries) {
            this.phoneNumberPrefixes = new int[this.numOfEntries];
        }
        if (this.descriptions == null || this.descriptions.length < this.numOfEntries) {
            this.descriptions = new String[this.numOfEntries];
        }
        for (int i = 0; i < this.numOfEntries; ++i) {
            this.phoneNumberPrefixes[i] = objectInput.readInt();
            this.descriptions[i] = objectInput.readUTF();
        }
        int sizeOfLengths = objectInput.readInt();
        this.possibleLengths.clear();
        for (int i = 0; i < sizeOfLengths; ++i) {
            this.possibleLengths.add(objectInput.readInt());
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.numOfEntries);
        for (int i = 0; i < this.numOfEntries; ++i) {
            objectOutput.writeInt(this.phoneNumberPrefixes[i]);
            objectOutput.writeUTF(this.descriptions[i]);
        }
        int sizeOfLengths = this.possibleLengths.size();
        objectOutput.writeInt(sizeOfLengths);
        for (Integer length : this.possibleLengths) {
            objectOutput.writeInt(length);
        }
    }
}

