% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{distance_matrix}
\alias{distance_matrix}
\title{Distance matrix for Dialectometry}
\usage{
distance_matrix(
  dialect_data,
  funname,
  alignment_normalization = FALSE,
  delim = NULL
)
}
\arguments{
\item{dialect_data}{A dataframe of dialect data, transcribed in the International Phonetic Alphabet.}

\item{funname}{The distance metric to be used. This can be chosen from the following: "leven", "vc_leven".}

\item{alignment_normalization}{A logical value, indicating whether or not the distance scores should be normalized by alignment length.}

\item{delim}{An optional delimiter, in situations where multiple responses exist in the data.}
}
\value{
A distance matrix, where the values are the difference between dialects based on edit distance.
}
\description{
Computes a distance matrix between dialect varieties, the results of which may be used for further analyses and plotting.
}
\examples{
data(Dutch)
Dutch <- Dutch[1:3,1:3]
distance_matrix(Dutch, funname = "vc_leven", alignment_normalization = TRUE)
}
