% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4_classes.R
\docType{class}
\name{REMB-class}
\alias{REMB-class}
\title{An S4 class to represent the results using the random effect model-based (REMB) algorithm.}
\description{
An S4 class to represent the results using the random effect model-based (REMB) algorithm.
}
\section{Slots}{

\describe{
\item{\code{dataTox}}{A data frame containing information for each patient at each simulation and trial.}

\item{\code{sim0}}{The simulation starting point; must be numeric.}

\item{\code{sim1}}{The simulation ending point; must be numeric.}

\item{\code{family}}{A distribution family for the response variable; defaults to binomial distribution. See \code{\link{glm}} and \code{\link{glmer}} for details.}

\item{\code{link}}{A specification for the model link function. This can be a name/expression, a literal character string or a length-one character vector; defaults to logit link function. See \code{\link{glmer}} for details.}

\item{\code{estimates}}{A data frame including the predicted toxicity probabilities (column named as "rndpt") using either the predicted random effect center "mu" (column named as "PredMu"), if it's available, or the value ratio (i.e. # of toxicities / # of subjects) if the corresponding "mu" is not available. Note that, "PredMu" value is equal to "NA" when there is no prediction for it.}
}}

