% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfidx.R
\name{dfidx}
\alias{dfidx}
\title{Data frames with indexes}
\usage{
dfidx(
  data,
  idx = NULL,
  drop.index = TRUE,
  as.factor = NULL,
  pkg = NULL,
  fancy.row.names = FALSE,
  subset = NULL,
  idnames = NULL,
  shape = c("long", "wide"),
  choice = NULL,
  varying = NULL,
  sep = ".",
  opposite = NULL,
  levels = NULL,
  ranked = FALSE,
  name,
  position,
  ...
)
}
\arguments{
\item{data}{a data frame}

\item{idx}{an index}

\item{drop.index}{if \code{TRUE} (the default), remove the index series
from the data.frame as stand alone series}

\item{as.factor}{should the indexes be coerced to factors ?}

\item{pkg}{if set, the resulting \code{dfidx} object is of class
\code{c("dfidx_pkg", "dfidx")} which enables to write specific
classes}

\item{fancy.row.names}{if \code{TRUE}, fancy row names are computed}

\item{subset}{a logical which defines a subset of rows to return}

\item{idnames}{the names of the indexes}

\item{shape}{either \code{wide} or \code{long}}

\item{choice}{the choice}

\item{varying, sep}{relevant for data sets in wide format, these
arguments are passed to reshape}

\item{opposite}{return the opposite of the series}

\item{levels}{the levels for the second index}

\item{ranked}{a boolean for ranked data}

\item{name}{name of the \code{idx} column}

\item{position}{position of the \code{idx} column}

\item{...}{further arguments}
}
\value{
an object of class \code{"dfidx"}
}
\description{
data frames for which observations are defined by two (potentialy
nested) indexes and for which series have thefore a natural tabular
representation
}
\details{
Indexes are stored as a \code{data.frame} column in the
resulting \code{dfidx} object
}
\examples{
# the first two columns contain the index
mn <- dfidx(munnell)

# explicitely indicate the two indexes using either a vector or a
# list of two characters
mn <- dfidx(munnell, idx = c("state", "year"))
mn <- dfidx(munnell, idx = list("state", "year"))

# rename one or both indexes
mn <- dfidx(munnell, idnames = c(NA, "period"))

# for balanced data (with observations ordered by the first, then
# by the second index

# use the name of the first index
mn <- dfidx(munnell, idx = "state", idnames = c("state", "year"))

# or an integer equal to the cardinal of the first index
mn <- dfidx(munnell, idx = 48, idnames = c("state", "year"))

# Indicate the values of the second index using the levels argument
mn <- dfidx(munnell, idx = 48, idnames = c("state", "year"),
            levels = 1970:1986)

# Nesting structure for one of the index
mn <- dfidx(munnell, idx = c(region = "state", president = "year"))

# Data in wide format
mn <- dfidx(munnell_wide, idx = c(region = "state"),
            varying = 3:36, sep = "_", idnames = c(NA, "year"))

# Customize the name and the position of the `idx` column
#dfidx(munnell, position = 3, name = "index")
}
\author{
Yves Croissant
}
