% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlpb.R
\name{MLPB_boot}
\alias{MLPB_boot}
\title{Multivariate Linear Process Bootstrap Method}
\usage{
MLPB_boot(dataList, output_dir, rois, timepoints, subset.subject = NULL,
  save_file_suffix = "", window_size = 20, number_of_intervals = 1,
  boot_rep = 250, n_boot = 1, cores = 1)
}
\arguments{
\item{dataList}{list, subject-specific data.}

\item{output_dir}{character, output directory for bootstrap samples.}

\item{rois}{vector of integers, specify the list of regions of interests}

\item{timepoints}{integer, number of timepoints in total}

\item{subset.subject}{vector of character, which subject to run, specify the index in \code{dataList}, for example, c(1, 2, ...)}

\item{save_file_suffix}{character, suffix of output files, treated as a labels.}

\item{window_size}{integer, window size for sliding window technique}

\item{number_of_intervals}{integer, number of intervals in sliding window technique}

\item{boot_rep}{integer, bootstrapping repetition times}

\item{n_boot}{integer, number of bootstrap sample to be generated in MLPB}

\item{cores}{integer, number of cores to register for parallel execution, if set to 1 a sequential job will be run}
}
\description{
Multivariate Linear Process Bootstrap (MLPB) method to assess the uncertainty in dynamic functional connectivity (dFC) by providing its confidence band.
}
\details{
The \code{dataList} parameter is a list of matrices which contains time series data of each region of interest (ROI). Output directory is required here because the results to be generate is massive.
}
\examples{
\dontshow{
# Load sample data
data(fMRI_dataList_shrinked)
MLPB_boot(fMRI_dataList_shrinked, output_dir=tempdir(), rois = 1:2, timepoints = 5, window_size=5)
rm(list=c('fMRI_dataList_shrinked'))
gc()
}
\donttest{

# Load sample data

data(fMRI_dataList)

MLPB_boot(fMRI_dataList, output_dir = tempdir(), 
          rois = c(54,191,235), 
          timepoints = 750)
}

}
\references{
Kudela et al. (2017) NeuroImage 10.1016/j.neuroimage.2017.01.056
(\href{https://www.ncbi.nlm.nih.gov/pubmed/28132931}{PubMed})
}
\keyword{bootstarpping}
