% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{distractor_plot}
\alias{distractor_plot}
\title{Distractor plot}
\usage{
distractor_plot(
  dataSrc,
  item_id,
  predicate = NULL,
  legend = TRUE,
  curtains = 10,
  adjust = 1,
  col = NULL,
  ...
)
}
\arguments{
\item{dataSrc}{a connection to a dexter database or a data.frame with columns: person_id, item_id, response, item_score
and optionally booklet_id}

\item{item_id}{The ID of the item to plot. A separate plot will be produced
for each booklet that contains the item, or an error message if the item_id
is not known. Each plot contains a non-parametric regression of each possible
response on the total score.}

\item{predicate}{An optional expression to subset data, if NULL all data is used}

\item{legend}{logical, whether to include the legend. default is TRUE}

\item{curtains}{100*the tail probability of the sum scores to be shaded. Default is 10.
Set to 0 to have no curtains shown at all.}

\item{adjust}{factor to adjust the smoothing bandwidth respective to the default value}

\item{col}{vector of colors to use for plotting}

\item{...}{further arguments to plot.}
}
\value{
Silently, a data.frame of response categories and colors used. Potentially useful if you want to customize the legend or 
print it separately
}
\description{
Produce a diagnostic distractor plot for an item
}
\details{
Customization of title and subtitle can be done by using the arguments main and sub. 
These arguments can contain references to the variables item_id, booklet_id, item_position(if available),
pvalue, rit and rir. References are made by prefixing these variables with a dollar sign. Variable names may be postfixed 
with a sprintf style format string, e.g. 
\code{distractor_plot(db, main='item: $item_id', sub='Item rest correlation: $rir:.2f')}
}
