% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enorm.R
\name{information}
\alias{information}
\alias{expected_score}
\title{Functions of theta}
\usage{
information(parms, items = NULL, booklet_id = NULL,
  which.draw = NULL)

expected_score(parms, items = NULL, booklet_id = NULL,
  which.draw = NULL)
}
\arguments{
\item{parms}{object produced by fit_enorm}

\item{items}{vector of one or more item_id's. If NULL and booklet_id is also NULL, all items in parms are used}

\item{booklet_id}{id of a single booklet (e.g. the test information function), if items is not NULL this is ignored}

\item{which.draw}{the number of the random draw (only applicable if calibration method was Bayes). If NULL, the mean 
beta parameter will be used}
}
\value{
a function which accepts a vector of theta's and returns an equal length vector 
with the information estimate or the expected score
}
\description{
returns information function or expected score function for a single item, an arbitrary group of items or all items
}
\examples{

db = start_new_project(verbAggrRules,':memory:')
add_booklet(db,verbAggrData, "agg")
p = fit_enorm(db)

# plot information function for single item

ifun = information(p, "S1DoScold")

plot(ifun,from=-4,to=4)

# compare test information function to the population ability distribution

ifun = information(p, booklet="agg")

pv = plausible_values(db,p)

op = par(no.readonly=TRUE)
par(mar = c(5,4,2,4))

plot(ifun,from=-4,to=4, xlab='theta', ylab='test information')

par(new=TRUE)

plot(density(pv$PV1), col='green', axes=FALSE,xlab=NA, ylab=NA,main=NA)
axis(side=4)
mtext(side = 4, line = 2.5, 'population density (green)')

par(op)
close_project(db)

}
