% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-decomp.R
\name{plot,decomp-method}
\alias{plot,decomp-method}
\title{Plot Method for Decomposition Results in the Style of Base R Plots}
\usage{
\S4method{plot}{decomp}(x, which = NULL, ...)
}
\arguments{
\item{x}{an object returned by the function \code{\link{deseats}}.}

\item{which}{various plots can be selected either via a keyword or a number; 
enter \code{"facets"} or \code{1} to show a facet plot of the estimated
time series components; enter \code{"observations"} or \code{2} to show the
input time series; enter \code{"fitted"} or \code{3} to show the observations 
alongside the estimated trend with seasonality; enter \code{"detailed_fit"} or
\code{4} to show the observations together with the fitted values and the trend;
enter \code{"trend_season"} or \code{5} to show the observations together with 
the trend and with the seasonality (the latter shown around the series mean);
enter \code{"residuals"} or 
\code{6} to plot the both detrended and seasonally adjusted series; use 
\code{7} or \code{"deseasonalized"} to show the seasonally adjusted 
series; enter \code{8} or \code{"detrended"} to plot the detrended 
series; the 
default is \code{which = NULL} which then lets you select a plot 
interactively in the R console.}

\item{...}{further arguments to pass to \code{\link[stats]{plot.ts}} or 
\code{\link[graphics]{matplot}} (depending on whether only one time series
or multiple time series are shown in the plot).}
}
\value{
A graphic is created in the plots windows, the function itself, however,
returns \code{NULL}.
}
\description{
This is method for producing various plots of the decomposition results
returned by this package.
}
\details{
Create predefined standard plots of the decomposition objects returned by the 
\code{deseats} package, e.g. returned by the function \code{\link{deseats}}. 
Plots are created in the base R plot style. The type of plot can be chosen 
either interactively from the console, or the argument \code{which} can be 
used to directly  select the kind of plot to create (see also the description
of the argument \code{which}) within the function call.

If plot type 5 (\code{which = 5}) is selected, the estimated 
seasonality will be displayed around the mean of the observations by default.
Setting the additional argument \code{s_around} to some other value, will lead 
to the seasonality being displayed around that constant value.
}
\examples{
Xt <- log(EXPENDITURES)
est <- deseats(Xt)
plot(est, which = 3)

}
\author{
\itemize{
\item Dominik Schulz (Research Assistant) (Department of Economics, Paderborn
University), \cr
Author and Package Creator
}
}
