% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds-screener.R
\name{ds_screener}
\alias{ds_screener}
\alias{screener}
\alias{plot.ds_screener}
\title{Screen Data Frames}
\usage{
ds_screener(y)

\method{plot}{ds_screener}(x, ...)
}
\arguments{
\item{y}{a data frame}

\item{x}{an object of class \code{ds_screener}}

\item{...}{further arguments to be passed to or from methods}
}
\value{
\code{ds_screener} returns an object of class \code{"ds_screener"}.
An object of class \code{"ds_screener"} is a list containing the
following components

\item{Rows}{number of rows in the data frame}
\item{Columns}{number of columns in the data frame}
\item{Variables}{names of the variables in the data frame}
\item{Types}{class of the variables in the data frame}
\item{Count}{length of the variables in the data frame}
\item{nlevels}{number of levels of a factor variable}
\item{levels}{levels of factor variables in the data frame}
\item{Missing}{number of missing observations in each variable}
\item{MissingPer}{Percent of missing observations in each variable}
\item{MissingTotal}{total number of missing observations in the data frame}
\item{MissingTotPer}{total percent of missing observations in the data frame}
\item{MissingRows}{total number of rows with missing observations in the
data frame}
\item{MissingCols}{total number of columns with missing observations in the
data frame}
}
\description{
\code{ds_screener} will screen data frames and return details such
as variable names, class, levels and missing values. \code{plot.ds_screener}
creates bar plots to visualize % of missing observations for each variable
in a data frame.
}
\section{Deprecated Function}{

\code{screener()} has been deprecated. Instead
use \code{ds_screener()}.
}

\examples{
# screen data
ds_screener(mtcarz)
}
