% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParamTransfoCompRisks.R
\name{LikI.bis}
\alias{LikI.bis}
\title{Second likelihood function needed to fit the independence model in the
second step of the estimation procedure.}
\usage{
LikI.bis(par, data, admin, conf, cf)
}
\arguments{
\item{par}{Vector of all second step model parameters, consisting of the
regression parameters, variance-covariance matrix elements and transformation
parameters.}

\item{data}{Data frame resulting from the 'uniformize.data.R' function.}

\item{admin}{Boolean value indicating whether the data contains
administrative censoring.}

\item{conf}{Boolean value indicating whether the data contains confounding
and hence indicating the presence of Z and W}

\item{cf}{"Control function" to be used. This can either be the (i) estimated
control function, (ii) the true control function, (iii) the instrumental
variable, or (iv) nothing (\code{cf = NULL}). Option (ii) is used when
comparing the two-step estimator to the oracle estimator, and option (iii) is
used to compare the two-step estimator with the naive estimator.}
}
\value{
Starting values for subsequent optimization function used in the
second step of the estimation procedure.
}
\description{
This function defines the log-likelihood used in estimating
the second step in the competing risks extension of the model described in
Willems et al. (2024+). The results of this function will serve as
starting values for subsequent optimizations (LikI.comprsk.R and
LikF.cmprsk.R)
}
\references{
Willems et al. (2024+). Flexible control function approach under competing risks (in preparation).
}
