% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_specific.R
\name{plot_specific}
\alias{plot_specific}
\title{plot_specific}
\usage{
plot_specific(
  result_daily_response,
  window_width,
  title = TRUE,
  ylimits = NULL,
  reference_window = "start",
  type = "daily"
)
}
\arguments{
\item{result_daily_response}{a list with three objects as produced by
daily_response function}

\item{window_width}{integer representing window width to be displayed}

\item{title}{logical, if set to FALSE, no plot title is displayed}

\item{ylimits}{limit of the y axes. It should be given as ylimits = c(0,1)}

\item{reference_window}{character string, the reference_window argument describes,
how each calculation is referred. There are three different options: 'start'
(default), 'end' and 'middle'. If the reference_window argument is set to 'start',
then each calculation is related to the starting day of window. If the
reference_window argument is set to 'middle', each calculation is related to the
middle day of window calculation. If the reference_window argument is set to
'end', then each calculation is related to the ending day of window calculation.
For example, if we consider correlations with window from DOY 15 to DOY 35. If
reference window is set to ‘start’, then this calculation will be related to the
DOY 15. If the reference window is set to ‘end’, then this calculation will be
related to the DOY 35. If the reference_window is set to 'middle', then this
calculation is related to DOY 25.}

\item{type}{the character string describing type of analysis: daily or monthly}
}
\value{
A ggplot2 object containing the plot display
}
\description{
Graphs a line plot of a row with a selected window width in a matrix,
produced by \code{\link{daily_response}} function.
}
\examples{
\dontrun{
data(LJ_daily_temperatures)
data(KRE_daily_temperatures)
data(example_proxies_1)
Example1 <- daily_response(response = example_proxies_1,
env_data = LJ_daily_temperatures, method = "lm", metric = "r.squared",
lower_limit = 90, upper_limit = 150, row_names_subset = TRUE,
previous_year = TRUE)
plot_specific(Example1, window_width = 90)

Example2 <- daily_response(response = data_TRW_1,
env_data = KRE_daily_temperatures, method = "cor",
metric = "adj.r.squared", lower_limit = 150, upper_limit = 155,
neurons = 1, row_names_subset = TRUE, previous_year = TRUE)
plot_specific(Example2, window_width = 153, title = TRUE)

Example3 <- daily_response(response = example_proxies_1,
env_data = LJ_daily_temperatures, method = "brnn",
metric = "adj.r.squared", lower_limit = 150, upper_limit = 155,
neurons = 1, previous_year = TRUE, row_names_subset = TRUE)
plot_specific(Example3, window_width = 153, title = TRUE)
}

}
\keyword{internal}
