% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/cluster-methods.R
\docType{methods}
\name{demi.comp.test}
\alias{demi.comp.test}
\title{Cluster probes into higher and lower clusters based on their differential signalling}
\usage{
demi.comp.test(x = "DEMIClust")
}
\arguments{
\item{x}{A \code{DEMIClust} object. The \code{DEMIClust} object containing normalized expression
values used for statistical significance test on differential signalling
of probes. The object contains the column indexes of groups (e.g. 'test'
and 'control') used in the analysis.}
}
\value{
A \code{list}. Returns a \code{list} containing different sets of probes that behave
		   similarly under current statistical test (e.g. up- or down-regulated probes).
}
\description{
Performs higher or lower comparison test on normalized expression matrix defined
in the \code{DEMIClust} object. Only probes whose expression values in one group
are all either bigger or smaller then the expression values in the comparative group
are termed with significant differential expression.
}
\examples{
\dontrun{

# To use the example we need to download a subset of CEL files from
# http://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE9819 published
# by Pradervand et al. 2008.

# Set the destination folder where the downloaded files fill be located.
# It can be any folder of your choosing.
destfolder <- "demitest/testdata/"

# Download packed CEL files and change the names according to the feature
# they represent (for example to include UHR or BRAIN in them to denote the
# features).
# It is good practice to name the files according to their features which
# allows easier identification of the files later.

ftpaddress <- "ftp://ftp.ncbi.nlm.nih.gov/geo/samples/GSM247nnn"
download.file( paste( ftpaddress, "GSM247694/suppl/GSM247694.CEL.gz", sep = "/" ),
		destfile = paste( destfolder, "UHR01_GSM247694.CEL.gz", sep = "" ) )
download.file( paste( ftpaddress, "GSM247695/suppl/GSM247695.CEL.gz", sep = "/" ),
		destfile = paste( destfolder, "UHR02_GSM247695.CEL.gz", sep = "" ) )
download.file( paste( ftpaddress, "GSM247698/suppl/GSM247698.CEL.gz", sep = "/" ),
		destfile = paste( destfolder, "UHR03_GSM247698.CEL.gz", sep = "" ) )
download.file( paste( ftpaddress, "GSM247699/suppl/GSM247699.CEL.gz", sep = "/" ),
		destfile = paste( destfolder, "UHR04_GSM247699.CEL.gz", sep = "" ) )
download.file( paste( ftpaddress, "GSM247696/suppl/GSM247696.CEL.gz", sep = "/" ),
		destfile = paste( destfolder, "BRAIN01_GSM247696.CEL.gz", sep = "" ) )
download.file( paste( ftpaddress, "GSM247697/suppl/GSM247697.CEL.gz", sep = "/" ),
		destfile = paste( destfolder, "BRAIN02_GSM247697.CEL.gz", sep = "" ) )
download.file( paste( ftpaddress, "GSM247700/suppl/GSM247700.CEL.gz", sep = "/" ),
		destfile = paste( destfolder, "BRAIN03_GSM247700.CEL.gz", sep = "" ) )
download.file( paste( ftpaddress, "GSM247701/suppl/GSM247701.CEL.gz", sep = "/" ),
		destfile = paste( destfolder, "BRAIN04_GSM247701.CEL.gz", sep = "" ) )

# We need the gunzip function (located in the R.utils package) to unpack the gz files.
# Also we will remove the original unpacked files for we won't need them.
library( R.utils )
for( i in list.files( destfolder ) ) {
	gunzip( paste( destfolder, i, sep = "" ), remove = TRUE )
}

# Now we can continue the example of the function demi.comp.test

# Basic experiment set up.
demiexp <- DEMIExperiment(analysis = 'gene', celpath = destfolder,
			experiment = 'myexperiment', organism = 'homo_sapiens')
#' # Create clusters with default behaviour
demiclust <- DEMIClust( demiexp, group = c( "BRAIN", "UHR" ) )

# Retrieve probes whose differential signalling was statistically significant
sigprobes <- demi.comp.test( demiclust )

# However it makes more sense to incorporate the method straight into \\code{DEMIClust} object
demiclust <- DEMIClust( demiexp, group = c( "BRAIN", "UHR" ), clust.method = demi.comp.test )

# Retrieve the probes whose differential signalling was statistically significant
sigprobes <- getCluster( demiclust )

# Retrieve the cluster names since we have both up-regulated and down-regulated probe clusters
names( sigprobes )

# Retrieve the up-regulated probes whose cluster names contain the sign '[H]'
head( sigprobes[[grep("\\\\[H\\\\]", names( sigprobes ))]] )

# Retrieve the down-regulated probes whose cluster names contain the sign '[L]'
head( sigprobes[[grep("\\\\[L\\\\]", names( sigprobes ))]] )

}
}
\author{
Sten Ilmjarv
}

