% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataPart.R
\name{createDataPartition}
\alias{createDataPartition}
\alias{createFolds}
\title{Data Partitioning}
\usage{
createDataPartition(forestdir, Nonforestdir, times = 1, p = 0.5)

createFolds(forestdir, Nonforestdir, k = 5)
}
\arguments{
\item{forestdir}{path to the directory with (only) forest images}

\item{Nonforestdir}{path to the directory with (only) non-forest images}

\item{times}{the number of data partitions to make}

\item{p}{the percentage of data to set aside for training}

\item{k}{the number of folds to split the data into}
}
\value{
createDataPartition returns a list of data partitions. Each partition consists of 4 sets- forest training,
non-forest training, forest test and non-forest test set. createFolds returns lists $forest and $nonforest with k folds in 
each of them.
}
\description{
As input data, the functions need two folders- Nonforestdir with images of non-forest and forestdir with ones of forest.
createDataPartition() splits data into training and testing partitions while keeping the relative sample size of the classes
the same as in the original data. createFolds() splits the data into k folds for cross-validation.
}
\section{Functions}{
\itemize{
\item \code{createFolds}: Split data into folds
}}

\examples{

library(deforestable)
forestdir <- system.file('extdata/Forest/', package = "deforestable")
Nonforestdir <- system.file('extdata/Non-forest/', package = "deforestable")

trainPart <- createDataPartition(forestdir=forestdir, Nonforestdir=Nonforestdir, p = .7, times = 1)

folds <- createFolds(forestdir, Nonforestdir, k = 10)

}
