% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers_scatterplot-layer.R
\name{add_scatterplot_layer}
\alias{add_scatterplot_layer}
\title{Add a scatterplot layer to the deckgl widget}
\usage{
add_scatterplot_layer(deckgl, id = "scatterplot-layer", data = NULL,
  properties = list(), ...)
}
\arguments{
\item{deckgl}{deckgl widget}

\item{id}{id of the layer}

\item{data}{url to fetch data from or data object}

\item{properties}{named list of properties with names corresponding to the properties defined
in the \href{https://deck.gl/#/documentation/deckgl-api-reference}{deckgl-api-reference}
for the given layer class, additionally there is a \code{getTooltip} property (callback)
showing a tooltip when the mouse enters an object,
e. g. \code{getTooltip = JS("object => object.name")}}

\item{...}{more properties (will be added to the properties object), useful if you
want to use a properties object for more than one layer}
}
\description{
The \code{ScatterplotLayer} takes in paired latitude and longitude coordinated points
and renders them as circles with a certain radius.
}
\examples{
## @knitr scatterplot-layer
data("bart_stations")

properties <- list(
  getPosition = ~lng + lat,
  getRadius = JS("data => Math.sqrt(data.exits)"),
  radiusScale = 6,
  getFillColor = c(255, 140, 20),
  getTooltip = ~name
)

deck <- deckgl(zoom = 10.5, pitch = 35) \%>\%
  add_scatterplot_layer(data = bart_stations, properties = properties) \%>\%
  add_mapbox_basemap()

if (interactive()) deck
}
\seealso{
\url{https://deck.gl/#/documentation/deckgl-api-reference/layers/scatterplot-layer}
}
